/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.distributable;

import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheFactory;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.distributable.DistributableStatefulSessionBeanCacheConfiguration;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.ejb.bean.BeanManagerConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagerFactory;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DistributableStatefulSessionBeanCacheFactoryServiceInstallerFactory<K, V extends StatefulSessionBeanInstance<K>>
implements BiFunction<StatefulComponentDescription, ServiceDependency<BeanManagerFactory<K, V>>, ServiceInstaller> {
    @Override
    public ServiceInstaller apply(StatefulComponentDescription description, final ServiceDependency<BeanManagerFactory<K, V>> managerFactory) {
        StatefulSessionBeanCacheFactory factory = new StatefulSessionBeanCacheFactory<K, V>(){

            @Override
            public StatefulSessionBeanCache<K, V> createStatefulBeanCache(final StatefulSessionBeanCacheConfiguration<K, V> configuration) {
                final Duration timeout = configuration.getTimeout();
                final Consumer<StatefulSessionBeanInstance> timeoutListener = StatefulSessionBeanInstance::removed;
                final BeanExpirationConfiguration expiration = timeout != null ? new BeanExpirationConfiguration<K, V>(){

                    public Duration getTimeout() {
                        return timeout;
                    }

                    public Consumer<V> getExpirationListener() {
                        return timeoutListener;
                    }
                } : null;
                final BeanManager manager = ((BeanManagerFactory)managerFactory.get()).createBeanManager(new BeanManagerConfiguration<K, V>(){

                    public Supplier<K> getIdentifierFactory() {
                        return configuration.getIdentifierFactory();
                    }

                    public String getBeanName() {
                        return configuration.getComponentName();
                    }

                    public BeanExpirationConfiguration<K, V> getExpiration() {
                        return expiration;
                    }
                });
                return new DistributableStatefulSessionBeanCache(new DistributableStatefulSessionBeanCacheConfiguration<K, V>(){

                    @Override
                    public StatefulSessionBeanInstanceFactory<V> getInstanceFactory() {
                        return configuration.getInstanceFactory();
                    }

                    @Override
                    public Supplier<K> getIdentifierFactory() {
                        return manager.getIdentifierFactory();
                    }

                    @Override
                    public BeanManager<K, V> getBeanManager() {
                        return manager;
                    }

                    @Override
                    public Duration getTimeout() {
                        return timeout;
                    }

                    @Override
                    public String getComponentName() {
                        return configuration.getComponentName();
                    }
                });
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)factory).provides(description.getCacheFactoryServiceName())).requires(managerFactory)).build();
    }
}

