/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.spi.Extension;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.modules.Module;
import org.jboss.vfs.VFSUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.loadAttachments(module, deploymentUnit, extensions);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
        }
    }

    private void loadAttachments(Module module, DeploymentUnit deploymentUnit, WeldPortableExtensions extensions) throws DeploymentUnitProcessingException {
        try {
            List<String> portableExtensionServices = this.loadServices(module, Extension.class.getName());
            List<String> buildCompatibleExtensionServices = this.loadServices(module, BuildCompatibleExtension.class.getName());
            List<Class<?>> loadedPortableExtensions = WeldPortableExtensionProcessor.loadExtensions(module, portableExtensionServices, Object.class);
            this.registerPortableExtensions(deploymentUnit, extensions, loadedPortableExtensions);
            for (Class<BuildCompatibleExtension> extensionClass : WeldPortableExtensionProcessor.loadExtensions(module, buildCompatibleExtensionServices, BuildCompatibleExtension.class)) {
                extensions.registerBuildCompatibleExtension(extensionClass);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private static <T> List<Class<? extends T>> loadExtensions(Module module, List<String> services, Class<T> type) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String service : services) {
            Class<T> extensionClass = WeldPortableExtensionProcessor.loadExtension(service, (ClassLoader)module.getClassLoader(), type);
            if (extensionClass == null) continue;
            result.add(extensionClass);
        }
        return result;
    }

    private void registerPortableExtensions(DeploymentUnit deploymentUnit, WeldPortableExtensions extensions, Collection<Class<?>> loadedExtensions) throws DeploymentUnitProcessingException {
        for (Class<?> loadedExtension : loadedExtensions) {
            extensions.tryRegisterExtension(loadedExtension, deploymentUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadServices(Module module, String resourceSuffix) throws IOException {
        Enumeration resources = module.getClassLoader().getResources("META-INF/services/" + resourceSuffix);
        ArrayList<String> services = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL resource = (URL)resources.nextElement();
            InputStream stream = resource.openStream();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    int commentIdx = line.indexOf(35);
                    String className = commentIdx == -1 ? line.trim() : line.substring(0, commentIdx).trim();
                    if (className.length() == 0) continue;
                    services.add(className);
                }
            }
            finally {
                VFSUtils.safeClose((Closeable)stream);
            }
        }
        return services;
    }

    private static <T> Class<? extends T> loadExtension(String serviceClassName, ClassLoader loader, Class<T> type) {
        try {
            return loader.loadClass(serviceClassName).asSubclass(type);
        }
        catch (Exception | LinkageError e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, e);
            return null;
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            deploymentUnit.removeAttachment(WeldPortableExtensions.ATTACHMENT_KEY);
        }
    }
}

