/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.util.Collection;
import java.util.List;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.projection.spi.ListProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.SingleValuedProjectionAccumulator;

public interface ProjectionAccumulator<E, V, A, R> {
    public static <V> Provider<V, V> single() {
        return SingleValuedProjectionAccumulator.PROVIDER;
    }

    public static <V> Provider<V, List<V>> list() {
        return ListProjectionAccumulator.PROVIDER;
    }

    public A createInitial();

    public A accumulate(A var1, E var2);

    default public A accumulateAll(A accumulated, Collection<E> values) {
        for (E value : values) {
            accumulated = this.accumulate(accumulated, value);
        }
        return accumulated;
    }

    public int size(A var1);

    public E get(A var1, int var2);

    public A transform(A var1, int var2, V var3);

    default public A transformAll(A accumulated, ProjectionConverter<? super E, ? extends V> converter, FromDocumentValueConvertContext context) {
        for (int i = 0; i < this.size(accumulated); ++i) {
            E initial = this.get(accumulated, i);
            V transformed = converter.fromDocumentValue(initial, context);
            accumulated = this.transform(accumulated, i, transformed);
        }
        return accumulated;
    }

    public R finish(A var1);

    public static interface Provider<U, R> {
        public <T> ProjectionAccumulator<T, U, ?, R> get();

        public boolean isSingleValued();
    }
}

