/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import io.netty.channel.Channel;
import java.lang.invoke.MethodHandles;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.DelegatingRemoteCache;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletableFutures;

public class InvalidatedNearRemoteCache<K, V>
extends DelegatingRemoteCache<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final NearCacheService<K, V> nearcache;
    private final ClientStatistics clientStatistics;
    private final AtomicInteger bloomFilterUpdateVersion;
    private final CacheOperationsFactory cacheOperationsFactory;
    private volatile Channel listenerChannel;

    InvalidatedNearRemoteCache(InternalRemoteCache<K, V> remoteCache, ClientStatistics clientStatistics, NearCacheService<K, V> nearcache) {
        super(remoteCache);
        this.clientStatistics = clientStatistics;
        this.nearcache = nearcache;
        this.bloomFilterUpdateVersion = nearcache.getBloomFilterBits() > 0 ? new AtomicInteger() : null;
        this.cacheOperationsFactory = remoteCache.getOperationsFactory().newFactoryFor(this);
    }

    @Override
    public CacheOperationsFactory getOperationsFactory() {
        return this.cacheOperationsFactory;
    }

    @Override
    <Key, Value> InternalRemoteCache<Key, Value> newDelegatingCache(InternalRemoteCache<Key, Value> innerCache) {
        return new InvalidatedNearRemoteCache<Key, Value>(innerCache, this.clientStatistics, this.nearcache);
    }

    public static <K, V> InvalidatedNearRemoteCache<K, V> delegatingNearCache(RemoteCacheImpl<K, V> remoteCache, NearCacheService<K, V> nearCacheService) {
        return new InvalidatedNearRemoteCache<K, V>(remoteCache, remoteCache.clientStatistics, nearCacheService);
    }

    @Override
    public CompletableFuture<V> getAsync(Object key) {
        CompletableFuture<MetadataValue<V>> value = this.getWithMetadataAsync(key);
        return value.thenApply(v -> v != null ? v.getValue() : null);
    }

    public int getCurrentVersion() {
        if (this.bloomFilterUpdateVersion != null) {
            return this.bloomFilterUpdateVersion.get();
        }
        return 0;
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        MetadataValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null || nearValue.getValue() == null) {
            this.clientStatistics.incrementNearCacheMisses();
            MetadataValueImpl<Object> calculatingPlaceholder = new MetadataValueImpl<Object>(-1L, -1, -1L, -1, -1L, null);
            boolean cache = this.nearcache.putIfAbsent(key, calculatingPlaceholder);
            int prevVersion = this.getCurrentVersion();
            CompletionStage remoteValue = super.getWithMetadataAsync(key, this.listenerChannel);
            if (!cache || (prevVersion & 1) == 1) {
                if (trace) {
                    log.tracef("Unable to cache returned value for key %s as either has concurrent operation or during a bloom filter update", org.infinispan.commons.util.Util.toStr(key));
                }
                this.nearcache.remove(key, calculatingPlaceholder);
                return remoteValue.toCompletableFuture().thenApply(GetWithMetadataOperation.GetWithMetadataResult::value);
            }
            return remoteValue.thenApply(v -> {
                MetadataValue value;
                boolean shouldRemove = true;
                MetadataValue metadataValue = value = v != null ? v.value() : null;
                if (value != null) {
                    if (prevVersion != this.getCurrentVersion()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was performed during a bloom filter update", org.infinispan.commons.util.Util.toStr((Object)key));
                        }
                    } else if (this.listenerChannel != null && v.retried()) {
                        if (trace) {
                            log.tracef("Unable to cache returned value for key %s as operation was retried", org.infinispan.commons.util.Util.toStr((Object)key));
                        }
                    } else {
                        this.nearcache.replace(key, calculatingPlaceholder, value);
                        if (value.getMaxIdle() > 0) {
                            Log.HOTROD.nearCacheMaxIdleUnsupported();
                        }
                        shouldRemove = false;
                    }
                }
                if (shouldRemove) {
                    this.nearcache.remove(key, calculatingPlaceholder);
                }
                return value;
            }).toCompletableFuture();
        }
        this.clientStatistics.incrementNearCacheHits();
        return CompletableFuture.completedFuture(nearValue);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        CompletableFuture<V> ret = super.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return ret.thenApply(v -> {
            this.nearcache.remove(key);
            return v;
        });
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit).thenRun(() -> map.keySet().forEach(this.nearcache::remove));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        if (maxIdleTime > 0L) {
            Log.HOTROD.nearCacheMaxIdleUnsupported();
        }
        return super.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdleTime, maxIdleTimeUnit).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.invalidateNearCacheIfNeeded(this.delegate.hasForceReturnFlag(), key, super.removeAsync(key));
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return super.removeWithVersionAsync(key, version).thenApply(removed -> {
            if (removed.booleanValue()) {
                this.nearcache.remove(key);
            }
            return removed;
        });
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return super.clearAsync().thenRun(this.nearcache::clear);
    }

    CompletableFuture<V> invalidateNearCacheIfNeeded(boolean hasForceReturnValue, Object key, CompletableFuture<V> prev) {
        return prev.thenApply(v -> {
            if (!hasForceReturnValue || v != null) {
                this.nearcache.remove(key);
            }
            return v;
        });
    }

    @Override
    public void resolveStorage(MediaType key, MediaType value) {
        if (key != null && !this.delegate.getRemoteCacheManager().getMarshaller().mediaType().match(key)) {
            Class marshallerClass = this.delegate.getRemoteCacheManager().getMarshaller().getClass();
            log.invalidateNearDefaultMarshallerMismatch(this.delegate.getName(), marshallerClass, key);
            this.listenerChannel = this.nearcache.start(this);
            this.delegate.resolveStorage(key, value);
        } else {
            this.delegate.resolveStorage(key, value);
            this.listenerChannel = this.nearcache.start(this);
        }
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
        super.stop();
    }

    public void clearNearCache() {
        this.nearcache.clear();
    }

    private boolean incrementBloomVersionIfEven() {
        int prev;
        do {
            if (((prev = this.bloomFilterUpdateVersion.get()) & 1) != 1) continue;
            return false;
        } while (!this.bloomFilterUpdateVersion.compareAndSet(prev, prev + 1));
        return true;
    }

    CompletionStage<Void> incrementBloomVersionUponCompletion(CompletionStage<Void> stage) {
        if (this.bloomFilterUpdateVersion != null) {
            return stage.whenComplete((ignore, t) -> this.bloomFilterUpdateVersion.incrementAndGet());
        }
        return stage;
    }

    @Override
    public CompletionStage<Void> updateBloomFilter() {
        if (this.bloomFilterUpdateVersion == null) {
            return CompletableFutures.completedNull();
        }
        if (!this.incrementBloomVersionIfEven()) {
            if (trace) {
                log.tracef("Already have a concurrent bloom filter update for listenerId(%s) - skipping", org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
            }
            return CompletableFuture.completedFuture(null);
        }
        byte[] bloomFilterBits = this.nearcache.calculateBloomBits();
        if (trace) {
            log.tracef("Sending bloom filter bits(%s) update to %s for listenerId(%s)", org.infinispan.commons.util.Util.printArray((byte[])bloomFilterBits), this.listenerChannel, org.infinispan.commons.util.Util.printArray((byte[])this.nearcache.getListenerId()));
        }
        CacheOperationsFactory operationsFactory = this.getOperationsFactory();
        HotRodOperation<Void> op = operationsFactory.newUpdateBloomFilterOperation(bloomFilterBits);
        return this.incrementBloomVersionUponCompletion(this.getDispatcher().executeOnSingleAddress(op, ChannelRecord.of(this.listenerChannel)));
    }

    public SocketAddress getBloomListenerAddress() {
        return ChannelRecord.of(this.listenerChannel);
    }

    public void setBloomListenerAddress(Channel channel) {
        this.listenerChannel = channel;
    }

    @Override
    public Channel addNearCacheListener(Object listener, int bloomBits) {
        ClientListenerOperation op = this.getOperationsFactory().newAddNearCacheListenerOperation(listener, bloomBits);
        return Util.await(this.getDispatcher().executeAddListener(op));
    }
}

