/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheEntryMetadata;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.cache.CacheEntryVersionImpl;

public class CacheEntryMetadataImpl<V>
implements CacheEntryMetadata {
    private final MetadataValue<V> metadataValue;
    private final CacheEntryExpiration expiration;
    private final CacheEntryVersion version;

    public CacheEntryMetadataImpl(MetadataValue<V> metadataValue) {
        this.metadataValue = metadataValue;
        this.expiration = CacheEntryMetadataImpl.getCacheExpiration(metadataValue.getLifespan(), metadataValue.getMaxIdle());
        this.version = new CacheEntryVersionImpl(metadataValue.getVersion());
    }

    public Optional<Instant> creationTime() {
        return this.metadataValue.getCreated() < 0L ? Optional.empty() : Optional.of(Instant.ofEpochMilli(this.metadataValue.getCreated()));
    }

    public Optional<Instant> lastAccessTime() {
        return this.metadataValue.getLastUsed() < 0L ? Optional.empty() : Optional.of(Instant.ofEpochMilli(this.metadataValue.getLastUsed()));
    }

    public CacheEntryExpiration expiration() {
        return this.expiration;
    }

    public CacheEntryVersion version() {
        return this.version;
    }

    public MetadataValue<V> getMetadataValue() {
        return this.metadataValue;
    }

    private static CacheEntryExpiration getCacheExpiration(long lifespan, long maxIdle) {
        if (lifespan < 0L) {
            if (maxIdle < 0L) {
                return CacheEntryExpiration.IMMORTAL;
            }
            return CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(maxIdle));
        }
        if (maxIdle < 0L) {
            return CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(lifespan));
        }
        return CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(lifespan), (Duration)Duration.ofSeconds(maxIdle));
    }
}

