/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.RandomElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SimpleElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonSubsystemSchema;
import org.wildfly.extension.clustering.singleton.XMLAttribute;
import org.wildfly.extension.clustering.singleton.XMLElement;

public class SingletonXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final SingletonSubsystemSchema schema;

    public SingletonXMLReader(SingletonSubsystemSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{SingletonResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader);
            switch (element) {
                case SINGLETON_POLICIES: {
                    this.parseSingletonPolicies(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseSingletonPolicies(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader, i);
            switch (attribute) {
                case DEFAULT: {
                    SingletonXMLReader.readAttribute(reader, i, operation, SingletonResourceDefinition.Attribute.DEFAULT);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader);
            switch (element) {
                case SINGLETON_POLICY: {
                    this.parseSingletonPolicy(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSingletonPolicy(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = XMLAttribute.NAME.require(reader);
        PathAddress address = subsystemAddress.append(new PathElement[]{SingletonPolicyResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader, i);
            switch (attribute) {
                case NAME: {
                    continue block10;
                }
                case CACHE_CONTAINER: {
                    SingletonXMLReader.readAttribute(reader, i, operation, SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER);
                    continue block10;
                }
                case CACHE: {
                    SingletonXMLReader.readAttribute(reader, i, operation, SingletonPolicyResourceDefinition.Attribute.CACHE);
                    continue block10;
                }
                case QUORUM: {
                    SingletonXMLReader.readAttribute(reader, i, operation, SingletonPolicyResourceDefinition.Attribute.QUORUM);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader);
            switch (element) {
                case RANDOM_ELECTION_POLICY: {
                    this.parseRandomElectionPolicy(reader, address, operations);
                    continue block11;
                }
                case SIMPLE_ELECTION_POLICY: {
                    this.parseSimpleElectionPolicy(reader, address, operations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRandomElectionPolicy(XMLExtendedStreamReader reader, PathAddress policyAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = policyAddress.append(new PathElement[]{RandomElectionPolicyResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        this.parsePreferences(reader, operation);
    }

    private void parseSimpleElectionPolicy(XMLExtendedStreamReader reader, PathAddress policyAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = policyAddress.append(new PathElement[]{SimpleElectionPolicyResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            XMLAttribute attribute = XMLAttribute.forName(reader, i);
            switch (attribute) {
                case POSITION: {
                    SingletonXMLReader.readAttribute(reader, i, operation, SimpleElectionPolicyResourceDefinition.Attribute.POSITION);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.parsePreferences(reader, operation);
    }

    private void parsePreferences(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            XMLElement element = XMLElement.forName(reader);
            switch (element) {
                case NAME_PREFERENCES: {
                    SingletonXMLReader.readElement(reader, operation, ElectionPolicyResourceDefinition.Attribute.NAME_PREFERENCES);
                    continue block4;
                }
                case SOCKET_BINDING_PREFERENCES: {
                    SingletonXMLReader.readElement(reader, operation, ElectionPolicyResourceDefinition.Attribute.SOCKET_BINDING_PREFERENCES);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void readAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getParser().parseAndSetParameter((AttributeDefinition)attribute.getDefinition(), reader.getAttributeValue(index), operation, (XMLStreamReader)reader);
    }

    private static void readElement(XMLExtendedStreamReader reader, ModelNode operation, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getParser().parseAndSetParameter((AttributeDefinition)attribute.getDefinition(), reader.getElementText(), operation, (XMLStreamReader)reader);
    }
}

