/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.remoting3.AbstractDelegatingMessageOutputStream;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;
import org.wildfly.common.Assert;

public final class MessageTracker {
    private final Channel channel;
    private final Object lock = new Object();
    private int counter;

    public MessageTracker(Channel channel, int limit) {
        Assert.checkNotNullParam("channel", channel);
        Assert.checkMinimumParameter("limit", 1, limit);
        this.channel = channel;
        this.counter = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageOutputStream openMessage() throws IOException, InterruptedException {
        Object lock;
        Object object = lock = this.lock;
        synchronized (object) {
            int counter = this.counter;
            while (counter == 0) {
                lock.wait();
                counter = this.counter;
            }
            this.counter = counter - 1;
        }
        return this.getMessageInstance(this.writeMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageOutputStream openMessageUninterruptibly() throws IOException {
        Object lock = this.lock;
        boolean intr = false;
        try {
            Object object = lock;
            synchronized (object) {
                int counter = this.counter;
                while (counter == 0) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException ex) {
                        intr = true;
                    }
                    counter = this.counter;
                }
                this.counter = counter - 1;
            }
            object = this.getMessageInstance(this.writeMessage());
            return object;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageOutputStream writeMessage() throws IOException {
        try {
            return this.channel.writeMessage();
        }
        catch (IOException e) {
            Object lock;
            Object object = lock = this.lock;
            synchronized (object) {
                ++this.counter;
                lock.notify();
            }
            throw e;
        }
    }

    private AbstractDelegatingMessageOutputStream getMessageInstance(MessageOutputStream delegate) {
        return new AbstractDelegatingMessageOutputStream(delegate){
            private final AtomicBoolean done;
            {
                this.done = new AtomicBoolean();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        super.close();
                    }
                    finally {
                        Object lock;
                        Object object = lock = MessageTracker.this.lock;
                        synchronized (object) {
                            MessageTracker.this.counter++;
                            lock.notify();
                        }
                    }
                }
            }
        };
    }
}

