/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.protocols.relay.RandomSiteMasterPicker;
import org.jgroups.protocols.relay.Route;

public class StickySiteMasterPicker
extends RandomSiteMasterPicker {
    protected Map<Address, Address> local_sm_cache = new ConcurrentHashMap<Address, Address>();
    protected Map<Address, Route> route_cache = new ConcurrentHashMap<Address, Route>();

    @Override
    public Address pickSiteMaster(List<Address> site_masters, Address original_sender) {
        Address existing;
        if (original_sender == null) {
            return super.pickSiteMaster(site_masters, original_sender);
        }
        Address local_sm = this.local_sm_cache.get(original_sender);
        if (local_sm != null) {
            if (site_masters.contains(local_sm)) {
                return local_sm;
            }
            this.local_sm_cache.remove(original_sender);
            local_sm = null;
        }
        return (existing = this.local_sm_cache.putIfAbsent(original_sender, local_sm = super.pickSiteMaster(site_masters, original_sender))) != null ? existing : local_sm;
    }

    @Override
    public Route pickRoute(String site, List<Route> routes, Address original_sender) {
        Route existing;
        if (original_sender == null) {
            return super.pickRoute(site, routes, original_sender);
        }
        Route route = this.route_cache.get(original_sender);
        if (route != null) {
            if (routes.contains(route)) {
                return route;
            }
            this.route_cache.remove(original_sender);
            route = null;
        }
        return (existing = this.route_cache.putIfAbsent(original_sender, route = super.pickRoute(site, routes, original_sender))) != null ? existing : route;
    }
}

