/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import sun.reflect.ReflectionFactory;

final class SerMethods {
    private static final ReflectionFactory reflectionFactory = AccessController.doPrivileged(ReflectionFactory::getReflectionFactory);
    private final MethodHandle readObject;
    private final MethodHandle readObjectNoData;
    private final MethodHandle writeObject;
    private final MethodHandle readResolve;
    private final MethodHandle writeReplace;
    private final Constructor<?> noArgConstructor;
    private final Constructor<?> objectInputConstructor;

    SerMethods(Class<?> clazz) {
        Constructor<?> ctor;
        this.readObject = SerMethods.changeType(reflectionFactory.readObjectForSerialization(clazz), MethodType.methodType(Void.TYPE, Object.class, ObjectInputStream.class));
        this.readObjectNoData = SerMethods.changeType(reflectionFactory.readObjectNoDataForSerialization(clazz), MethodType.methodType(Void.TYPE, Object.class));
        this.writeObject = SerMethods.changeType(reflectionFactory.writeObjectForSerialization(clazz), MethodType.methodType(Void.TYPE, Object.class, ObjectOutputStream.class));
        this.readResolve = SerMethods.changeType(reflectionFactory.readResolveForSerialization(clazz), MethodType.methodType(Object.class, Object.class));
        this.writeReplace = SerMethods.changeType(reflectionFactory.writeReplaceForSerialization(clazz), MethodType.methodType(Object.class, Object.class));
        Constructor<?> noArgConstructor = null;
        try {
            ctor = clazz.getDeclaredConstructor(new Class[0]);
            noArgConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.noArgConstructor = noArgConstructor;
        Constructor<?> objectInputConstructor = null;
        try {
            ctor = clazz.getDeclaredConstructor(ObjectInput.class);
            objectInputConstructor = reflectionFactory.newConstructorForSerialization(clazz, ctor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.objectInputConstructor = objectInputConstructor;
    }

    private static MethodHandle changeType(MethodHandle original, MethodType newType) {
        return original == null ? null : original.asType(newType);
    }

    static Constructor<?> newConstructorForSerialization(Class<?> classToInstantiate, Constructor<?> constructorToCall) {
        return reflectionFactory.newConstructorForSerialization(classToInstantiate, constructorToCall);
    }

    boolean hasWriteObject() {
        return this.writeObject != null;
    }

    void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        try {
            this.writeObject.invokeExact(object, outputStream);
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    boolean hasReadObject() {
        return this.readObject != null;
    }

    void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        try {
            this.readObject.invokeExact(object, inputStream);
        }
        catch (IOException | ClassNotFoundException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    boolean hasReadObjectNoData() {
        return this.readObjectNoData != null;
    }

    void callReadObjectNoData(Object object) throws ObjectStreamException {
        try {
            this.readObjectNoData.invokeExact(object);
        }
        catch (ObjectStreamException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    boolean hasWriteReplace() {
        return this.writeReplace != null;
    }

    Object callWriteReplace(Object object) throws ObjectStreamException {
        try {
            return this.writeReplace.invokeExact(object);
        }
        catch (ObjectStreamException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    boolean hasReadResolve() {
        return this.readResolve != null;
    }

    Object callReadResolve(Object object) throws ObjectStreamException {
        try {
            return this.readResolve.invokeExact(object);
        }
        catch (ObjectStreamException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    Constructor<?> getNoArgConstructor() {
        return this.noArgConstructor;
    }

    Constructor<?> getObjectInputConstructor() {
        return this.objectInputConstructor;
    }
}

