/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.registry.otlp.internal.CircularCountHolder;
import io.micrometer.registry.otlp.internal.DefaultExponentialHistogramSnapShot;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import io.micrometer.registry.otlp.internal.IndexProvider;
import io.micrometer.registry.otlp.internal.IndexProviderFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public abstract class Base2ExponentialHistogram
implements Histogram {
    private final int maxScale;
    private final int maxBucketsCount;
    private final double zeroThreshold;
    @Nullable
    private final TimeUnit baseUnit;
    private final LongAdder zeroCount = new LongAdder();
    private CircularCountHolder circularCountHolder;
    private IndexProvider base2IndexProvider;
    private int scale;

    Base2ExponentialHistogram(int maxScale, int maxBucketsCount, double minimumExpectedValue, @Nullable TimeUnit baseUnit) {
        this.maxScale = maxScale;
        this.scale = maxScale;
        this.maxBucketsCount = maxBucketsCount;
        this.baseUnit = baseUnit;
        this.zeroThreshold = Base2ExponentialHistogram.getZeroThreshHoldFromMinExpectedValue(minimumExpectedValue, baseUnit);
        this.circularCountHolder = new CircularCountHolder(maxBucketsCount);
        this.base2IndexProvider = IndexProviderFactory.getIndexProviderForScale(this.scale);
    }

    private static double getZeroThreshHoldFromMinExpectedValue(double minimumExpectedValue, @Nullable TimeUnit baseUnit) {
        double minValueScaledToTime = baseUnit != null ? TimeUtils.nanosToUnit((double)minimumExpectedValue, (TimeUnit)baseUnit) : minimumExpectedValue;
        return Math.max(Math.nextDown(minValueScaledToTime), 0.0);
    }

    public abstract ExponentialHistogramSnapShot getLatestExponentialHistogramSnapshot();

    abstract void takeExponentialHistogramSnapShot();

    int getScale() {
        return this.scale;
    }

    public HistogramSnapshot takeSnapshot(long count, double total, double max) {
        this.takeExponentialHistogramSnapShot();
        return new HistogramSnapshot(count, total, max, null, null, null);
    }

    ExponentialHistogramSnapShot getCurrentValuesSnapshot() {
        return this.circularCountHolder.isEmpty() && this.zeroCount.longValue() == 0L ? DefaultExponentialHistogramSnapShot.getEmptySnapshotForScale(this.scale) : new DefaultExponentialHistogramSnapShot(this.scale, this.zeroCount.longValue(), this.zeroThreshold, new ExponentialHistogramSnapShot.ExponentialBuckets(this.getOffset(), this.getBucketCounts()), ExponentialHistogramSnapShot.ExponentialBuckets.EMPTY_EXPONENTIAL_BUCKET);
    }

    public void recordLong(long value) {
        this.recordDouble(value);
    }

    public void recordDouble(double value) {
        if (this.baseUnit != null) {
            value = TimeUtils.nanosToUnit((double)value, (TimeUnit)this.baseUnit);
        }
        if (value <= this.zeroThreshold) {
            this.zeroCount.increment();
            return;
        }
        this.recordToHistogram(value);
    }

    private synchronized void recordToHistogram(double value) {
        int index = this.base2IndexProvider.getIndexForValue(value);
        if (!this.circularCountHolder.increment(index, 1L)) {
            int downScaleFactor = this.getDownScaleFactor(index);
            this.downScale(downScaleFactor);
            index = this.base2IndexProvider.getIndexForValue(value);
            this.circularCountHolder.increment(index, 1L);
        }
    }

    private void downScale(int downScaleFactor) {
        if (downScaleFactor == 0) {
            return;
        }
        if (!this.circularCountHolder.isEmpty()) {
            CircularCountHolder newCounts = new CircularCountHolder(this.maxBucketsCount);
            for (int i = this.circularCountHolder.getStartIndex(); i <= this.circularCountHolder.getEndIndex(); ++i) {
                long count = this.circularCountHolder.getValueAtIndex(i);
                if (count <= 0L) continue;
                newCounts.increment(i >> downScaleFactor, count);
            }
            this.circularCountHolder = newCounts;
        }
        this.updateScale(this.scale - downScaleFactor);
    }

    private void updateScale(int newScale) {
        if (newScale > this.maxScale) {
            newScale = this.maxScale;
        }
        this.scale = newScale;
        this.base2IndexProvider = IndexProviderFactory.getIndexProviderForScale(this.scale);
    }

    private int getDownScaleFactor(long index) {
        long newStart = Math.min(index, (long)this.circularCountHolder.getStartIndex());
        long newEnd = Math.max(index, (long)this.circularCountHolder.getEndIndex());
        int scaleDownFactor = 0;
        while (newEnd - newStart + 1L > (long)this.maxBucketsCount) {
            newStart >>= 1;
            newEnd >>= 1;
            ++scaleDownFactor;
        }
        return scaleDownFactor;
    }

    private int getUpscaleFactor() {
        if (!this.circularCountHolder.isEmpty()) {
            int indexDelta = this.circularCountHolder.getEndIndex() - this.circularCountHolder.getStartIndex() + 1;
            if (indexDelta == 1) {
                return this.maxScale - this.scale;
            }
            return (int)Math.floor(Math.log((double)this.maxBucketsCount / (double)indexDelta) / Math.log(2.0));
        }
        return this.maxScale - this.scale;
    }

    private int getOffset() {
        if (this.circularCountHolder.isEmpty()) {
            return 0;
        }
        return this.circularCountHolder.getStartIndex();
    }

    private List<Long> getBucketCounts() {
        if (this.circularCountHolder.isEmpty()) {
            return Collections.emptyList();
        }
        int length = this.circularCountHolder.getEndIndex() - this.circularCountHolder.getStartIndex() + 1;
        long[] countsArr = new long[length];
        for (int i = 0; i < length; ++i) {
            countsArr[i] = this.circularCountHolder.getValueAtIndex(i + this.circularCountHolder.getStartIndex());
        }
        return Arrays.stream(countsArr).boxed().collect(Collectors.toList());
    }

    synchronized void reset() {
        int upscaleFactor = this.getUpscaleFactor();
        if (upscaleFactor > 0) {
            this.updateScale(this.scale + upscaleFactor);
        }
        this.circularCountHolder.reset();
        this.zeroCount.reset();
    }
}

