/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.List;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;

final class PredicateOptimisations {
    private PredicateOptimisations() {
    }

    public static PredicateComparisonResult comparePrimaryPredicates(boolean isFirstNegated, PrimaryPredicateExpr first, boolean isSecondNegated, PrimaryPredicateExpr second) {
        if (first.getClass() == second.getClass()) {
            if (first instanceof ComparisonExpr) {
                ComparisonExpr comparison1 = (ComparisonExpr)first;
                ComparisonExpr comparison2 = (ComparisonExpr)second;
                assert (comparison1.getLeftChild() instanceof PropertyValueExpr);
                assert (comparison1.getRightChild() instanceof ConstantValueExpr);
                assert (comparison2.getLeftChild() instanceof PropertyValueExpr);
                assert (comparison2.getRightChild() instanceof ConstantValueExpr);
                if (comparison1.getLeftChild().equals(comparison2.getLeftChild()) && comparison1.getRightChild().equals(comparison2.getRightChild())) {
                    ComparisonExpr.Type cmpType1 = comparison1.getComparisonType();
                    if (isFirstNegated) {
                        cmpType1 = cmpType1.negate();
                    }
                    ComparisonExpr.Type cmpType2 = comparison2.getComparisonType();
                    if (isSecondNegated) {
                        cmpType2 = cmpType2.negate();
                    }
                    return cmpType1 == cmpType2 ? PredicateComparisonResult.IDENTICAL : (cmpType1 == cmpType2.negate() ? PredicateComparisonResult.OPPOSITE : PredicateComparisonResult.UNRELATED);
                }
            } else if (first.equals(second)) {
                return isFirstNegated == isSecondNegated ? PredicateComparisonResult.IDENTICAL : PredicateComparisonResult.OPPOSITE;
            }
        }
        return PredicateComparisonResult.UNRELATED;
    }

    public static void optimizePredicates(List<BooleanExpr> children, boolean isConjunction) {
        PredicateOptimisations.removeRedundantPredicates(children, isConjunction);
        PredicateOptimisations.optimizeOverlappingIntervalPredicates(children, isConjunction);
    }

    private static void removeRedundantPredicates(List<BooleanExpr> children, boolean isConjunction) {
        for (int i = 0; i < children.size(); ++i) {
            BooleanExpr ci = children.get(i);
            if (ci instanceof BooleanOperatorExpr || ci instanceof FullTextBoostExpr || ci instanceof FullTextOccurExpr) continue;
            boolean isCiNegated = ci instanceof NotExpr;
            if (isCiNegated) {
                ci = ((NotExpr)ci).getChild();
            }
            assert (ci instanceof PrimaryPredicateExpr);
            PrimaryPredicateExpr ci1 = (PrimaryPredicateExpr)ci;
            assert (ci1.getChild() instanceof PropertyValueExpr);
            PropertyValueExpr pve = (PropertyValueExpr)ci1.getChild();
            if (pve.isRepeated()) continue;
            int j = i + 1;
            while (j < children.size()) {
                BooleanExpr cj = children.get(j);
                if (!(cj instanceof BooleanOperatorExpr || cj instanceof FullTextBoostExpr || cj instanceof FullTextOccurExpr)) {
                    boolean isCjNegated = cj instanceof NotExpr;
                    if (isCjNegated) {
                        cj = ((NotExpr)cj).getChild();
                    }
                    assert (cj instanceof PrimaryPredicateExpr);
                    PrimaryPredicateExpr cj1 = (PrimaryPredicateExpr)cj;
                    assert (cj1.getChild() instanceof PropertyValueExpr);
                    PropertyValueExpr pve2 = (PropertyValueExpr)cj1.getChild();
                    if (!pve2.isRepeated()) {
                        PredicateComparisonResult res = PredicateOptimisations.comparePrimaryPredicates(isCiNegated, ci1, isCjNegated, cj1);
                        if (res == PredicateComparisonResult.IDENTICAL) {
                            children.remove(j);
                            continue;
                        }
                        if (res == PredicateComparisonResult.OPPOSITE) {
                            children.clear();
                            children.add(ConstantBooleanExpr.forBoolean(!isConjunction));
                            return;
                        }
                    }
                }
                ++j;
            }
        }
    }

    private static void optimizeOverlappingIntervalPredicates(List<BooleanExpr> children, boolean isConjunction) {
        for (int i = 0; i < children.size(); ++i) {
            BooleanExpr ci = children.get(i);
            if (!(ci instanceof ComparisonExpr)) continue;
            ComparisonExpr first = (ComparisonExpr)ci;
            assert (first.getLeftChild() instanceof PropertyValueExpr);
            assert (first.getRightChild() instanceof ConstantValueExpr);
            PropertyValueExpr pve = (PropertyValueExpr)first.getLeftChild();
            if (pve.isRepeated()) continue;
            int j = i + 1;
            while (j < children.size()) {
                BooleanExpr cj = children.get(j);
                if (cj instanceof ComparisonExpr) {
                    BooleanExpr res;
                    ComparisonExpr second = (ComparisonExpr)cj;
                    assert (second.getLeftChild() instanceof PropertyValueExpr);
                    assert (second.getRightChild() instanceof ConstantValueExpr);
                    PropertyValueExpr pve2 = (PropertyValueExpr)second.getLeftChild();
                    if (!pve2.isRepeated() && first.getLeftChild().equals(second.getLeftChild()) && (res = PredicateOptimisations.optimizeOverlappingIntervalPredicates(first, second, isConjunction)) != null) {
                        if (res instanceof ConstantBooleanExpr) {
                            children.clear();
                            children.add(res);
                            return;
                        }
                        children.remove(j);
                        if (res == first) continue;
                        first = (ComparisonExpr)res;
                        children.set(i, first);
                        continue;
                    }
                }
                ++j;
            }
        }
    }

    private static BooleanExpr optimizeOverlappingIntervalPredicates(ComparisonExpr first, ComparisonExpr second, boolean isConjunction) {
        ConstantValueExpr firstConstant = (ConstantValueExpr)first.getRightChild();
        ConstantValueExpr secondConstant = (ConstantValueExpr)second.getRightChild();
        if (firstConstant.isParameter() || secondConstant.isParameter()) {
            return null;
        }
        Comparable firstValue = firstConstant.getConstantValue();
        Comparable secondValue = secondConstant.getConstantValue();
        int cmp = firstValue.compareTo(secondValue);
        if (first.getComparisonType() == ComparisonExpr.Type.EQUAL) {
            return PredicateOptimisations.optimizeEqAndInterval(first, second, isConjunction, cmp);
        }
        if (second.getComparisonType() == ComparisonExpr.Type.EQUAL) {
            return PredicateOptimisations.optimizeEqAndInterval(second, first, isConjunction, -cmp);
        }
        if (first.getComparisonType() == ComparisonExpr.Type.NOT_EQUAL) {
            return PredicateOptimisations.optimizeNotEqAndInterval(first, second, isConjunction, cmp);
        }
        if (second.getComparisonType() == ComparisonExpr.Type.NOT_EQUAL) {
            return PredicateOptimisations.optimizeNotEqAndInterval(second, first, isConjunction, -cmp);
        }
        if (cmp == 0) {
            if (first.getComparisonType() == second.getComparisonType()) {
                return first;
            }
            if (first.getComparisonType() == second.getComparisonType().negate()) {
                return isConjunction ? ConstantBooleanExpr.FALSE : ConstantBooleanExpr.TRUE;
            }
            if (first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL || first.getComparisonType() == ComparisonExpr.Type.GREATER_OR_EQUAL) {
                return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.EQUAL) : ConstantBooleanExpr.TRUE;
            }
            return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.NOT_EQUAL);
        }
        if (first.getComparisonType() == second.getComparisonType().negate() || first.getComparisonType() == second.getComparisonType().reverse()) {
            if (cmp < 0) {
                if (first.getComparisonType() == ComparisonExpr.Type.LESS || first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL) {
                    if (isConjunction) {
                        return ConstantBooleanExpr.FALSE;
                    }
                } else if (!isConjunction) {
                    return ConstantBooleanExpr.TRUE;
                }
            } else if (first.getComparisonType() == ComparisonExpr.Type.GREATER || first.getComparisonType() == ComparisonExpr.Type.GREATER_OR_EQUAL) {
                if (isConjunction) {
                    return ConstantBooleanExpr.FALSE;
                }
            } else if (!isConjunction) {
                return ConstantBooleanExpr.TRUE;
            }
            return null;
        }
        if (first.getComparisonType() == ComparisonExpr.Type.LESS || first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL) {
            if (isConjunction) {
                return cmp < 0 ? first : second;
            }
            return cmp < 0 ? second : first;
        }
        if (isConjunction) {
            return cmp < 0 ? second : first;
        }
        return cmp < 0 ? first : second;
    }

    private static BooleanExpr optimizeEqAndInterval(ComparisonExpr first, ComparisonExpr second, boolean isConjunction, int cmp) {
        assert (first.getComparisonType() == ComparisonExpr.Type.EQUAL);
        switch (second.getComparisonType()) {
            case EQUAL: {
                if (cmp == 0) {
                    return first;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case NOT_EQUAL: {
                if (cmp == 0) {
                    return ConstantBooleanExpr.forBoolean(!isConjunction);
                }
                return isConjunction ? first : null;
            }
            case LESS: {
                if (cmp == 0) {
                    return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.LESS_OR_EQUAL);
                }
                if (cmp < 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case LESS_OR_EQUAL: {
                if (cmp <= 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case GREATER: {
                if (cmp == 0) {
                    return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.GREATER_OR_EQUAL);
                }
                if (cmp > 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case GREATER_OR_EQUAL: {
                if (cmp >= 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
        }
        return null;
    }

    private static BooleanExpr optimizeNotEqAndInterval(ComparisonExpr first, ComparisonExpr second, boolean isConjunction, int cmp) {
        assert (first.getComparisonType() == ComparisonExpr.Type.NOT_EQUAL);
        switch (second.getComparisonType()) {
            case EQUAL: {
                if (cmp == 0) {
                    return ConstantBooleanExpr.FALSE;
                }
                return isConjunction ? second : first;
            }
            case NOT_EQUAL: {
                if (cmp == 0) {
                    return first;
                }
                return isConjunction ? null : ConstantBooleanExpr.TRUE;
            }
            case LESS: {
                if (cmp >= 0) {
                    return isConjunction ? second : first;
                }
                return isConjunction ? null : ConstantBooleanExpr.TRUE;
            }
            case LESS_OR_EQUAL: {
                if (cmp < 0) {
                    return isConjunction ? null : ConstantBooleanExpr.TRUE;
                }
                if (cmp > 0) {
                    return isConjunction ? second : first;
                }
                return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.LESS) : ConstantBooleanExpr.TRUE;
            }
            case GREATER: {
                if (cmp > 0) {
                    return isConjunction ? null : ConstantBooleanExpr.TRUE;
                }
                return isConjunction ? second : first;
            }
            case GREATER_OR_EQUAL: {
                if (cmp < 0) {
                    return isConjunction ? second : first;
                }
                if (cmp > 0) {
                    return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.GREATER) : ConstantBooleanExpr.TRUE;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
        }
        return null;
    }

    static enum PredicateComparisonResult {
        IDENTICAL,
        OPPOSITE,
        UNRELATED;

    }
}

