/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.Externalizable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.marshalling.ClassTable;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledKey;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.jboss.IdentityClassTable;

enum DefaultClassTableProvider implements Supplier<ClassTable>
{
    IO(List.of(Externalizable.class, Serializable.class)),
    LANG(List.of(Class.class, StackTraceElement.class)),
    MATH(List.of(BigDecimal.class, BigInteger.class, MathContext.class, RoundingMode.class)),
    NET(List.of(InetAddress.getLoopbackAddress().getClass(), InetSocketAddress.class, URI.class, URL.class)),
    SQL(List.of(Date.class, Time.class, Timestamp.class)),
    TIME(List.of(Clock.systemDefaultZone().getClass(), DayOfWeek.class, Duration.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, Month.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZoneId.systemDefault().getClass(), ZoneOffset.class, ZonedDateTime.class)),
    CONCURRENT_ATOMIC(List.of(AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, AtomicReference.class)),
    CONCURRENT(List.of(ArrayBlockingQueue.class, ConcurrentHashMap.class, ConcurrentHashMap.newKeySet().getClass(), ConcurrentLinkedDeque.class, ConcurrentLinkedQueue.class, ConcurrentSkipListMap.class, ConcurrentSkipListSet.class, CopyOnWriteArrayList.class, CopyOnWriteArraySet.class, LinkedBlockingDeque.class, LinkedBlockingQueue.class, LinkedTransferQueue.class, PriorityBlockingQueue.class, SynchronousQueue.class, TimeUnit.class)),
    UTIL(List.of(Collections.checkedCollection(List.of(), Void.class).getClass(), Collections.checkedList(List.of(), Void.class).getClass(), Collections.checkedList(new LinkedList<E>(), Void.class).getClass(), Collections.checkedMap(Map.of(), Void.class, Void.class).getClass(), Collections.checkedNavigableMap(Collections.emptyNavigableMap(), Void.class, Void.class).getClass(), Collections.checkedNavigableSet(Collections.emptyNavigableSet(), Void.class).getClass(), Collections.checkedQueue(new LinkedList<E>(), Void.class).getClass(), Collections.checkedSet(Set.of(), Void.class).getClass(), Collections.checkedSortedMap(Collections.emptySortedMap(), Void.class, Void.class).getClass(), Collections.checkedSortedSet(Collections.emptySortedSet(), Void.class).getClass(), Collections.singleton(null).getClass(), Collections.singletonList(null).getClass(), Collections.singletonMap(null, null).getClass(), Collections.synchronizedCollection(List.of()).getClass(), Collections.synchronizedList(List.of()).getClass(), Collections.synchronizedList(new LinkedList<E>()).getClass(), Collections.synchronizedMap(Map.of()).getClass(), Collections.synchronizedNavigableMap(Collections.emptyNavigableMap()).getClass(), Collections.synchronizedNavigableSet(Collections.emptyNavigableSet()).getClass(), Collections.synchronizedSet(Set.of()).getClass(), Collections.synchronizedSortedMap(Collections.emptySortedMap()).getClass(), Collections.synchronizedSortedSet(Collections.emptySortedSet()).getClass(), Collections.unmodifiableCollection(List.of()).getClass(), Collections.unmodifiableList(List.of()).getClass(), Collections.unmodifiableList(new LinkedList<E>()).getClass(), Collections.unmodifiableMap(Map.of()).getClass(), Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass(), Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass(), Collections.unmodifiableSet(Set.of()).getClass(), Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass(), Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass(), Collections.newSetFromMap(Map.of()).getClass(), ArrayDeque.class, ArrayList.class, BitSet.class, Currency.class, java.util.Date.class, EnumMap.class, EnumSet.noneOf(Locale.IsoCountryCode.class).getClass(), EnumSet.noneOf(Character.UnicodeScript.class).getClass(), GregorianCalendar.class, HashMap.class, HashSet.class, Hashtable.class, IdentityHashMap.class, LinkedHashMap.class, LinkedHashSet.class, LinkedList.class, List.of().getClass(), List.of(Boolean.TRUE, Boolean.FALSE).getClass(), Locale.class, Map.of().getClass(), Map.of(Boolean.TRUE, Boolean.FALSE).getClass(), PriorityQueue.class, Properties.class, Set.of().getClass(), Set.of(Boolean.TRUE, Boolean.FALSE).getClass(), SimpleTimeZone.class, TimeZone.getDefault().getClass(), TreeMap.class, TreeSet.class, UUID.class, Vector.class)),
    MARSHALLING(List.of(ByteBufferMarshalledKey.class, ByteBufferMarshalledValue.class));

    private final ClassTable table;

    private static List<Class<?>> findSerializableClasses(Class<?> targetClass) {
        Class<?>[] childClasses = targetClass.getDeclaredClasses();
        return childClasses.length > 0 ? Stream.concat(Stream.of(targetClass), Stream.of(childClasses).filter(Serializable.class::isAssignableFrom)).toList() : List.of(targetClass);
    }

    private DefaultClassTableProvider(List<Class<?>> classes) {
        this.table = new IdentityClassTable(classes.stream().map(DefaultClassTableProvider::findSerializableClasses).flatMap(Collection::stream).toList());
    }

    @Override
    public ClassTable get() {
        return this.table;
    }
}

