/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.SSLOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.http.HttpClientRequest;
import io.vertx.mutiny.core.http.HttpClientResponse;
import io.vertx.mutiny.core.http.HttpConnection;
import io.vertx.mutiny.core.http.WebSocket;
import io.vertx.mutiny.core.metrics.Measured;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClient(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    HttpClient() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @CheckReturnValue
    public Uni<HttpClientRequest> request(RequestOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.request(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public HttpClientRequest requestAndAwait(RequestOptions options) {
        return (HttpClientRequest)this.request(options).await().indefinitely();
    }

    public void requestAndForget(RequestOptions options) {
        this.request(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.request(method, port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public HttpClientRequest requestAndAwait(HttpMethod method, int port, String host, String requestURI) {
        return (HttpClientRequest)this.request(method, port, host, requestURI).await().indefinitely();
    }

    public void requestAndForget(HttpMethod method, int port, String host, String requestURI) {
        this.request(method, port, host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.request(method, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public HttpClientRequest requestAndAwait(HttpMethod method, String host, String requestURI) {
        return (HttpClientRequest)this.request(method, host, requestURI).await().indefinitely();
    }

    public void requestAndForget(HttpMethod method, String host, String requestURI) {
        this.request(method, host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<HttpClientRequest> request(HttpMethod method, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.request(method, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> HttpClientRequest.newInstance(event)))));
    }

    public HttpClientRequest requestAndAwait(HttpMethod method, String requestURI) {
        return (HttpClientRequest)this.request(method, requestURI).await().indefinitely();
    }

    public void requestAndForget(HttpMethod method, String requestURI) {
        this.request(method, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<WebSocket> webSocket(int port, String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.webSocket(port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    @Deprecated
    public WebSocket webSocketAndAwait(int port, String host, String requestURI) {
        return (WebSocket)this.webSocket(port, host, requestURI).await().indefinitely();
    }

    @Deprecated
    public void webSocketAndForget(int port, String host, String requestURI) {
        this.webSocket(port, host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<WebSocket> webSocket(String host, String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.webSocket(host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    @Deprecated
    public WebSocket webSocketAndAwait(String host, String requestURI) {
        return (WebSocket)this.webSocket(host, requestURI).await().indefinitely();
    }

    @Deprecated
    public void webSocketAndForget(String host, String requestURI) {
        this.webSocket(host, requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<WebSocket> webSocket(String requestURI) {
        return AsyncResultUni.toUni(handler -> this.delegate.webSocket(requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    @Deprecated
    public WebSocket webSocketAndAwait(String requestURI) {
        return (WebSocket)this.webSocket(requestURI).await().indefinitely();
    }

    @Deprecated
    public void webSocketAndForget(String requestURI) {
        this.webSocket(requestURI).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<WebSocket> webSocket(WebSocketConnectOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.webSocket(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    @Deprecated
    public WebSocket webSocketAndAwait(WebSocketConnectOptions options) {
        return (WebSocket)this.webSocket(options).await().indefinitely();
    }

    @Deprecated
    public void webSocketAndForget(WebSocketConnectOptions options) {
        this.webSocket(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    @Deprecated
    public Uni<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return AsyncResultUni.toUni(handler -> this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    @Deprecated
    public WebSocket webSocketAbsAndAwait(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return (WebSocket)this.webSocketAbs(url, headers, version, subProtocols).await().indefinitely();
    }

    @Deprecated
    public void webSocketAbsAndForget(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        this.webSocketAbs(url, headers, version, subProtocols).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options) {
        return (Boolean)this.updateSSLOptions(options).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options) {
        this.updateSSLOptions(options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultUni.toUni(handler -> this.delegate.updateSSLOptions(options, force, handler));
    }

    public Boolean updateSSLOptionsAndAwait(SSLOptions options, boolean force) {
        return (Boolean)this.updateSSLOptions(options, force).await().indefinitely();
    }

    public void updateSSLOptionsAndForget(SSLOptions options, boolean force) {
        this.updateSSLOptions(options, force).subscribe().with(UniHelper.NOOP);
    }

    @Deprecated
    @Fluent
    private HttpClient __connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new DelegatingHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    @Deprecated
    public HttpClient connectionHandler(Consumer<HttpConnection> handler) {
        return this.__connectionHandler((Handler<HttpConnection>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Deprecated
    @Fluent
    public HttpClient redirectHandler(final Function<HttpClientResponse, Uni<RequestOptions>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, Future<RequestOptions>>(){

            @Override
            public Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                return UniHelper.toFuture((Uni)((Uni)handler.apply(HttpClientResponse.newInstance(arg))));
            }
        });
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

