/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.ServerGroupAddHandler;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentReplaceHandler;
import org.jboss.as.domain.controller.resources.DomainDeploymentOverlayDefinition;
import org.jboss.as.domain.controller.resources.DomainDeploymentResourceDefinition;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final String SERVER_GROUP_CAPABILITY_NAME = "org.wildfly.domain.server-group";
    public static final RuntimeCapability<Void> SERVER_GROUP_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.domain.server-group", (boolean)true).build();
    public static final PathElement PATH = PathElement.pathElement((String)"server-group");
    public static final SimpleAttributeDefinition PROFILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"profile", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new StringLengthValidator(1))).setCapabilityReference("org.wildfly.domain.profile", "org.wildfly.domain.server-group")).addArbitraryDescriptor("feature-reference", ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-group", (ModelType)ModelType.STRING, (boolean)false).setXmlName(Attribute.REF.getLocalName())).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.domain.socket-binding-group", "org.wildfly.domain.server-group")).addArbitraryDescriptor("feature-reference", ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_DEFAULT_INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding-default-interface", ModelType.STRING, true).setAllowExpression(false)).setXmlName(Attribute.DEFAULT_INTERFACE.getLocalName())).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING_PORT_OFFSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-binding-port-offset", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(ModelNode.ZERO)).setXmlName(Attribute.PORT_OFFSET.getLocalName())).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-65535, 65535, true, true))).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_SUBSYSTEM_ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-subsystem-endpoint", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES)).build();
    public static final SimpleAttributeDefinition GRACEFUL_STARTUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"graceful-startup", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    public static final AttributeDefinition[] ADD_ATTRIBUTES = new AttributeDefinition[]{PROFILE, SOCKET_BINDING_GROUP, SOCKET_BINDING_DEFAULT_INTERFACE, SOCKET_BINDING_PORT_OFFSET, MANAGEMENT_SUBSYSTEM_ENDPOINT, GRACEFUL_STARTUP};
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;

    public ServerGroupResourceDefinition(boolean master, LocalHostControllerInfo hostInfo, HostFileRepository fileRepository) {
        this(master, hostInfo, fileRepository, null);
    }

    public ServerGroupResourceDefinition(boolean master, LocalHostControllerInfo hostInfo, HostFileRepository fileRepository, ContentRepository contentRepository) {
        super(new SimpleResourceDefinition.Parameters(PATH, DomainResolver.getResolver("server-group", false)).setAddHandler(ServerGroupAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)new ServerGroupRemoveHandler(hostInfo)).addCapabilities(new RuntimeCapability[]{SERVER_GROUP_CAPABILITY}));
        this.contentRepository = contentRepository;
        this.fileRepository = fileRepository;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        OperationStepHandler referenceValidationHandler = ServerGroupResourceDefinition.createRestartRequiredHandler();
        for (AttributeDefinition attr : ADD_ATTRIBUTES) {
            if (attr.getName().equals(MANAGEMENT_SUBSYSTEM_ENDPOINT.getName())) {
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_SUBSYSTEM_ENDPOINT, null);
                continue;
            }
            if (attr.getName().equals(PROFILE.getName()) || attr.getName().equals(SOCKET_BINDING_GROUP.getName())) {
                resourceRegistration.registerReadWriteAttribute(attr, null, referenceValidationHandler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, ModelOnlyWriteAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(DeploymentAttributes.SERVER_GROUP_REPLACE_DEPLOYMENT_DEFINITION, (OperationStepHandler)new ServerGroupDeploymentReplaceHandler(this.fileRepository, this.contentRepository));
        DomainServerLifecycleHandlers.registerServerGroupHandlers(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)JvmResourceDefinition.GLOBAL);
        resourceRegistration.registerSubModel((ResourceDefinition)DomainDeploymentResourceDefinition.createForServerGroup(this.fileRepository, this.contentRepository));
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForDomainOrHost((SystemPropertyResourceDefinition.Location)SystemPropertyResourceDefinition.Location.SERVER_GROUP));
        resourceRegistration.registerSubModel((ResourceDefinition)new DomainDeploymentOverlayDefinition(false, null, null));
    }

    public static OperationStepHandler createRestartRequiredHandler() {
        return ServerRestartRequiredWriteAttributeHandler.INSTANCE;
    }

    private static class ServerRestartRequiredWriteAttributeHandler
    extends ModelOnlyWriteAttributeHandler {
        public static OperationStepHandler INSTANCE = new ServerRestartRequiredWriteAttributeHandler();

        private ServerRestartRequiredWriteAttributeHandler() {
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, Resource resource) throws OperationFailedException {
            if (newValue.equals(currentValue)) {
                ServerOperationResolver.addToDontPropagateToServersAttachment(context, operation);
            }
        }
    }
}

