/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.embedded;

import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.Future;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerEnvironmentWrapper;
import org.jboss.as.host.controller.Main;
import org.jboss.as.host.controller.embedded.EmbeddedHostControllerBootstrap;
import org.jboss.as.host.controller.embedded.SecurityActions;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.server.ElapsedTime;
import org.jboss.as.server.embedded.AbstractEmbeddedProcessBootstrap;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;

public final class HostEmbeddedProcessBootstrap
extends AbstractEmbeddedProcessBootstrap {
    private static final String MODULE_PATH = "-mp";
    private static final String PC_ADDRESS = "--pc-address";
    private static final String PC_PORT = "--pc-port";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    private static final String SYSPROP_KEY_JBOSS_DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    private static final String[] DOMAIN_KEYS = new String[]{"jboss.domain.base.dir", "jboss.domain.config.dir", "jboss.domain.deployment.dir", "jboss.domain.temp.dir", "jboss.domain.log.dir", "jboss.domain.config.dir"};

    public EmbeddedProcessBootstrap.Type getType() {
        return EmbeddedProcessBootstrap.Type.HOST_CONTROLLER;
    }

    protected Future<ServiceContainer> bootstrapEmbeddedProcess(ElapsedTime elapsedTime, EmbeddedProcessBootstrapConfiguration configuration, ServiceActivator ... extraServices) throws Exception {
        HostControllerEnvironment environment = HostEmbeddedProcessBootstrap.createHostControllerEnvironment(configuration.getJBossHome(), configuration.getCmdArgs(), elapsedTime);
        if (environment == null) {
            return null;
        }
        byte[] authBytes = new byte[16];
        new Random(new SecureRandom().nextLong()).nextBytes(authBytes);
        String pcAuthCode = Base64.getEncoder().encodeToString(authBytes);
        EmbeddedHostControllerBootstrap hostControllerBootstrap = new EmbeddedHostControllerBootstrap(environment, pcAuthCode);
        try {
            return hostControllerBootstrap.bootstrap(extraServices);
        }
        catch (Exception ex) {
            hostControllerBootstrap.failed();
            throw ex;
        }
    }

    private static HostControllerEnvironment createHostControllerEnvironment(File jbossHome, String[] cmdargs, ElapsedTime elapsedTime) {
        SecurityActions.setPropertyPrivileged("jboss.home.dir", jbossHome.getAbsolutePath());
        ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(cmdargs));
        if (SecurityActions.getPropertyPrivileged("jboss.domain.primary.address", null) == null) {
            SecurityActions.setPropertyPrivileged("jboss.domain.primary.address", "127.0.0.1");
        }
        cmds.add(MODULE_PATH);
        cmds.add(SecurityActions.getPropertyPrivileged("module.path", ""));
        cmds.add(PC_ADDRESS);
        cmds.add("0");
        cmds.add(PC_PORT);
        cmds.add("0");
        cmds.add("--admin-only");
        for (String prop : DOMAIN_KEYS) {
            String value = SecurityActions.getPropertyPrivileged(prop, null);
            if (value == null) continue;
            cmds.add("-D" + prop + "=" + value);
        }
        HostControllerEnvironmentWrapper wrapper = Main.determineEnvironment(cmds.toArray(new String[0]), elapsedTime, ProcessType.EMBEDDED_HOST_CONTROLLER);
        if (wrapper.getHostControllerEnvironmentStatus() == HostControllerEnvironmentWrapper.HostControllerEnvironmentStatus.ERROR) {
            throw HostControllerLogger.ROOT_LOGGER.cannotCreateHostControllerEnvironment();
        }
        return wrapper.getHostControllerEnvironment();
    }
}

