/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import javax.naming.InitialContext;
import org.jboss.jca.core.tx.noopts.TransactionImpl;
import org.jboss.jca.core.tx.noopts.TxRegistry;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final String JNDI_NAME = "java:/TransactionSynchronizationRegistry";
    private transient TxRegistry registry = null;

    public void setRegistry(TxRegistry v) {
        this.registry = v;
    }

    public Object getTransactionKey() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx != null) {
            return tx.getKey();
        }
        return null;
    }

    public void putResource(Object key, Object value) {
        TransactionImpl tx = this.registry.getTransaction();
        tx.putResource(key, value);
    }

    public Object getResource(Object key) {
        TransactionImpl tx = this.registry.getTransaction();
        return tx.getResource(key);
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        try {
            tx.registerSynchronization(sync);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getTransactionStatus() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            return 6;
        }
        try {
            return tx.getStatus();
        }
        catch (Throwable t) {
            return 5;
        }
    }

    public void setRollbackOnly() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        try {
            tx.setRollbackOnly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean getRollbackOnly() {
        TransactionImpl tx = this.registry.getTransaction();
        if (tx == null) {
            throw new IllegalStateException();
        }
        return tx.getRollbackOnly();
    }

    public void start() throws Throwable {
        InitialContext context = new InitialContext();
        context.bind(JNDI_NAME, (Object)this);
        context.close();
    }

    public void stop() throws Throwable {
        InitialContext context = new InitialContext();
        context.unbind(JNDI_NAME);
        context.close();
    }
}

