/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Objects;
import org.wildfly.common.Assert;
import org.wildfly.discovery.ServiceDesignation;
import org.wildfly.discovery.ServiceURL;

public final class ServiceType
extends ServiceDesignation {
    private static final long serialVersionUID = -6374415301360797195L;
    private final String abstractType;
    private final String abstractTypeAuthority;
    private final String uriScheme;
    private final String uriSchemeAuthority;
    private transient String toString;

    ServiceType(String abstractType, String abstractTypeAuthority, String uriScheme, String uriSchemeAuthority) {
        this.abstractType = abstractType;
        this.abstractTypeAuthority = abstractTypeAuthority;
        this.uriScheme = uriScheme;
        this.uriSchemeAuthority = uriSchemeAuthority;
    }

    @Override
    public boolean implies(ServiceDesignation other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        if (other instanceof ServiceType) {
            return this.implies((ServiceType)other);
        }
        assert (other instanceof ServiceURL);
        return this.implies((ServiceURL)other);
    }

    public boolean implies(ServiceType serviceType) {
        Assert.checkNotNullParam((String)"serviceType", (Object)serviceType);
        return Objects.equals(this.abstractType, serviceType.abstractType) && Objects.equals(this.abstractTypeAuthority, serviceType.abstractTypeAuthority) && (this.uriScheme == null || this.uriScheme.equals(serviceType.uriScheme) && Objects.equals(this.uriSchemeAuthority, serviceType.uriSchemeAuthority));
    }

    public boolean implies(ServiceURL serviceURL) {
        if (this.uriScheme == null) {
            if (serviceURL.getAbstractType() == null) {
                return Objects.equals(this.abstractType, serviceURL.getUriScheme()) && Objects.equals(this.abstractTypeAuthority, serviceURL.getUriSchemeAuthority());
            }
            return Objects.equals(this.abstractType, serviceURL.getAbstractType()) && Objects.equals(this.abstractTypeAuthority, serviceURL.getAbstractTypeAuthority());
        }
        return Objects.equals(this.abstractType, serviceURL.getAbstractType()) && Objects.equals(this.abstractTypeAuthority, serviceURL.getAbstractTypeAuthority()) && Objects.equals(this.uriScheme, serviceURL.getUriScheme()) && Objects.equals(this.uriSchemeAuthority, serviceURL.getUriSchemeAuthority());
    }

    public boolean equals(ServiceType other) {
        return other != null && Objects.equals(this.abstractType, other.abstractType) && Objects.equals(this.abstractTypeAuthority, other.abstractTypeAuthority) && Objects.equals(this.uriScheme, other.uriScheme) && Objects.equals(this.uriSchemeAuthority, other.uriSchemeAuthority);
    }

    @Override
    public boolean equals(ServiceDesignation other) {
        return other instanceof ServiceType && this.equals((ServiceType)other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ServiceType && this.equals((ServiceType)other);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + 17 * (this.abstractType.hashCode() + 17 * this.abstractTypeAuthority.hashCode());
    }

    @Override
    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            toString = this.toString = this.toString(new StringBuilder(32)).toString();
        }
        return toString;
    }

    StringBuilder toString(StringBuilder b) {
        b.append("service:").append(this.abstractType);
        if (this.abstractTypeAuthority != null) {
            b.append('.').append(this.abstractTypeAuthority);
        }
        if (this.uriScheme != null) {
            b.append(':').append(this.uriScheme);
            if (this.uriSchemeAuthority != null) {
                b.append('.').append(this.uriSchemeAuthority);
            }
        }
        return b;
    }

    @Override
    public final String getAbstractType() {
        return this.abstractType;
    }

    @Override
    public final String getAbstractTypeAuthority() {
        return this.abstractTypeAuthority;
    }

    @Override
    public String getUriScheme() {
        return this.uriScheme;
    }

    @Override
    public String getUriSchemeAuthority() {
        return this.uriSchemeAuthority;
    }

    public static ServiceType of(String abstractType, String abstractTypeAuthority) {
        Assert.checkNotNullParam((String)"abstractType", (Object)abstractType);
        return new ServiceType(abstractType, abstractTypeAuthority, null, null);
    }

    public static ServiceType of(String abstractType, String abstractTypeAuthority, String concreteType, String concreteTypeAuthority) {
        Assert.checkNotNullParam((String)"abstractType", (Object)abstractType);
        Assert.checkNotNullParam((String)"concreteType", (Object)concreteType);
        return new ServiceType(abstractType, abstractTypeAuthority, concreteType, concreteTypeAuthority);
    }
}

