/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.util.concurrent.WithinThreadExecutor;

final class CQDelete
extends CQWorker {
    CQDelete() {
    }

    @Override
    CompletionStage<QueryResponse> perform(BitSet segments) {
        this.setFilter(segments);
        if (this.queryDefinition.getFirstResult() != 0 || this.queryDefinition.isCustomMaxResults()) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        int concurrencyLevel = this.cache.getCacheConfiguration().locking().concurrencyLevel();
        SearchQueryBuilder query = this.queryDefinition.getSearchQueryBuilder();
        return this.blockingManager.supplyBlocking(() -> this.fetchIds(query), (Object)this).thenCompose(queryResult -> CompletionStages.performConcurrently((Iterable)queryResult, (int)concurrencyLevel, (Scheduler)Schedulers.from((Executor)new WithinThreadExecutor()), key -> this.cache.removeAsync(key).thenApply(Objects::nonNull), Collectors.summingInt(prev -> prev != false ? 1 : 0))).thenApply(QueryResponse::new);
    }

    public List<Object> fetchIds(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        List result = query.ids().fetchAllHits();
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }
}

