/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.ExistsPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.KnnPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.KnnPredicateVectorStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.NestedPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RegexpQueryFlag;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateOptionsStep;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.DistanceToFieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.FieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.KnnPredicate;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NestedExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinBoxExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinCircleExpr;
import org.infinispan.objectfilter.impl.syntax.SpatialWithinPolygonExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.CacheValueAggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.FunctionPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.dsl.embedded.impl.DistanceUnitHelper;
import org.infinispan.query.dsl.embedded.impl.InfinispanAggregation;
import org.infinispan.query.dsl.embedded.impl.SearchProjectionInfo;
import org.infinispan.query.dsl.embedded.impl.SearchQueryParsingResult;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;
import org.jboss.logging.Logger;

public final class SearchQueryMaker<TypeMetadata>
implements Visitor<PredicateFinalStep, PredicateFinalStep> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)SearchQueryMaker.class.getName());
    private static final char LUCENE_SINGLE_CHARACTER_WILDCARD = '?';
    private static final char LUCENE_MULTIPLE_CHARACTERS_WILDCARD = '*';
    private static final char LUCENE_WILDCARD_ESCAPE_CHARACTER = '\\';
    private final SearchMapping searchMapping;
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    private final int maxResults;
    private final int hitCountAccuracy;
    private Map<String, Object> namedParameters;
    private LuceneSearchPredicateFactory predicateFactory;
    private SearchIndexedEntity indexedEntity;
    private Integer knn;
    private BooleanExpr filteringClause;

    SearchQueryMaker(SearchMapping searchMapping, ObjectPropertyHelper<TypeMetadata> propertyHelper, int maxResults, int hitCountAccuracy) {
        this.searchMapping = searchMapping;
        this.propertyHelper = propertyHelper;
        this.maxResults = maxResults;
        this.hitCountAccuracy = hitCountAccuracy;
    }

    public SearchQueryParsingResult transform(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, Class<?> targetedType, String targetedTypeName) {
        if (this.searchMapping == null) {
            throw log.noTypeIsIndexed(parsingResult.getQueryString());
        }
        this.namedParameters = namedParameters;
        SearchSession querySession = this.searchMapping.getMappingSession();
        SearchScope<?> scope = targetedTypeName == null ? querySession.scope(targetedType) : querySession.scope(targetedType, targetedTypeName);
        this.predicateFactory = (LuceneSearchPredicateFactory)scope.predicate().extension((SearchPredicateFactoryExtension)LuceneExtension.get());
        this.indexedEntity = targetedTypeName == null ? this.searchMapping.indexedEntity(targetedType) : this.searchMapping.indexedEntity(targetedTypeName);
        this.filteringClause = parsingResult.getFilteringClause();
        InfinispanAggregation aggregation = this.makeAggregation(scope, parsingResult);
        SearchPredicate predicate = this.makePredicate(parsingResult.getWhereClause(), aggregation).toPredicate();
        SearchProjectionInfo projection = this.makeProjection(parsingResult.getTargetEntityMetadata(), scope.projection(), parsingResult.getProjectedPaths(), parsingResult.getProjectedTypes(), aggregation);
        SearchSort sort = this.makeSort(scope.sort(), parsingResult.getSortFields());
        return new SearchQueryParsingResult(targetedType, targetedTypeName, projection, aggregation, predicate, sort, this.hitCountAccuracy, this.knn);
    }

    private <T> InfinispanAggregation makeAggregation(SearchScope<?> scope, IckleParsingResult<TypeMetadata> parsingResult) {
        PropertyPath[] groupBy = parsingResult.getGroupBy();
        if (groupBy == null || groupBy.length != 1) {
            return null;
        }
        AggregationPropertyPath aggregationPropertyPath = null;
        Class projectedType = null;
        boolean displayGroupFirst = false;
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath projectedPath = parsingResult.getProjectedPaths()[i];
            if (projectedPath instanceof AggregationPropertyPath) {
                if (projectedType != null) {
                    displayGroupFirst = true;
                }
                aggregationPropertyPath = (AggregationPropertyPath)projectedPath;
                continue;
            }
            if (!Arrays.equals(groupBy[0].asArrayPath(), projectedPath.asArrayPath())) continue;
            projectedType = parsingResult.getProjectedTypes()[i];
        }
        if (aggregationPropertyPath == null || projectedType == null) {
            return null;
        }
        SearchAggregation searchAggregation = scope.aggregation().terms().field(groupBy[0].asStringPathWithoutAlias(), projectedType).maxTermCount(Integer.MAX_VALUE).toAggregation();
        return new InfinispanAggregation(searchAggregation, aggregationPropertyPath, displayGroupFirst);
    }

    private SearchProjectionInfo makeProjection(TypeMetadata typeMetadata, SearchProjectionFactory<EntityReference, ?> projectionFactory, PropertyPath<?>[] projections, Class<?>[] projectedTypes, InfinispanAggregation aggregation) {
        if (projections == null || projections.length == 0 || aggregation != null) {
            return SearchProjectionInfo.entity(projectionFactory);
        }
        if (projections.length == 1) {
            String projection = projections[0].asStringPath();
            if ("__HSearch_This".equals(projection)) {
                return SearchProjectionInfo.entity(projectionFactory);
            }
            if ("__ISPN_Key".equals(projection)) {
                return SearchProjectionInfo.entityReference(projectionFactory);
            }
            boolean isRepeatedProperty = this.propertyHelper.isRepeatedProperty(typeMetadata, projections[0].asArrayPath());
            if (projections[0] instanceof FunctionPropertyPath) {
                final FunctionPropertyPath distance = (FunctionPropertyPath)projections[0];
                DistanceToFieldProjectionValueStep projectionStep = projectionFactory.distance(projection, new GeoPoint(){

                    public double latitude() {
                        return (Double)distance.getArgs().get(0);
                    }

                    public double longitude() {
                        return (Double)distance.getArgs().get(1);
                    }
                });
                if (distance.getArgs().size() > 2) {
                    String unit = (String)distance.getArgs().get(2);
                    DistanceUnit distanceUnit = DistanceUnitHelper.distanceUnit(unit);
                    projectionStep.unit(distanceUnit);
                }
                return SearchProjectionInfo.composite(projectionFactory, new SearchProjection[]{isRepeatedProperty ? projectionStep.multi().toProjection() : projectionStep.toProjection()});
            }
            if (isRepeatedProperty) {
                return SearchProjectionInfo.multiField(projectionFactory, projection, projectedTypes[0]);
            }
            return SearchProjectionInfo.field(projectionFactory, projection, projectedTypes[0]);
        }
        SearchProjection[] searchProjections = new SearchProjection[projections.length];
        for (int i = 0; i < projections.length; ++i) {
            String projection = projections[i].asStringPath();
            if ("__HSearch_This".equals(projection)) {
                searchProjections[i] = projectionFactory.entity().toProjection();
                continue;
            }
            if ("__ISPN_Key".equals(projection)) {
                searchProjections[i] = projectionFactory.entityReference().toProjection();
                continue;
            }
            if ("__ISPN_Score".equals(projections[i])) {
                searchProjections[i] = projectionFactory.score().toProjection();
                continue;
            }
            boolean isMultiField = this.propertyHelper.isRepeatedProperty(typeMetadata, projections[i].asArrayPath());
            if (projections[i] instanceof FunctionPropertyPath) {
                final FunctionPropertyPath distance = (FunctionPropertyPath)projections[i];
                DistanceToFieldProjectionValueStep projectionStep = projectionFactory.distance(projection, new GeoPoint(){

                    public double latitude() {
                        return (Double)distance.getArgs().get(0);
                    }

                    public double longitude() {
                        return (Double)distance.getArgs().get(1);
                    }
                });
                if (distance.getArgs().size() > 2) {
                    String unit = (String)distance.getArgs().get(2);
                    DistanceUnit distanceUnit = DistanceUnitHelper.distanceUnit(unit);
                    projectionStep.unit(distanceUnit);
                }
                searchProjections[i] = isMultiField ? projectionStep.multi().toProjection() : projectionStep.toProjection();
                continue;
            }
            FieldProjectionValueStep projectionStep = projectionFactory.field(projection, projectedTypes[i]);
            searchProjections[i] = isMultiField ? projectionStep.multi().toProjection() : projectionStep.toProjection();
        }
        return SearchProjectionInfo.composite(projectionFactory, searchProjections);
    }

    private SearchSort makeSort(SearchSortFactory sortFactory, SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return sortFactory.score().toSort();
        }
        if (sortFields.length == 1) {
            return this.makeSort(sortFactory, sortFields[0]);
        }
        CompositeSortComponentsStep composite = sortFactory.composite();
        for (SortField sortField : sortFields) {
            composite.add(this.makeSort(sortFactory, sortField));
        }
        return composite.toSort();
    }

    private SearchSort makeSort(SearchSortFactory sortFactory, SortField sortField) {
        PropertyPath path = sortField.getPath();
        if (path instanceof FunctionPropertyPath) {
            FunctionPropertyPath functionPath = (FunctionPropertyPath)path;
            Double lat = (Double)functionPath.getArgs().get(0);
            Double lon = (Double)functionPath.getArgs().get(1);
            DistanceSortOptionsStep optionsStep = sortFactory.distance(functionPath.asStringPathWithoutAlias(), lat.doubleValue(), lon.doubleValue());
            return (sortField.isAscending() ? (DistanceSortOptionsStep)optionsStep.asc() : (DistanceSortOptionsStep)optionsStep.desc()).toSort();
        }
        FieldSortOptionsStep optionsStep = sortFactory.field(path.asStringPathWithoutAlias());
        return (sortField.isAscending() ? (FieldSortOptionsStep)optionsStep.asc() : (FieldSortOptionsStep)optionsStep.desc()).toSort();
    }

    private PredicateFinalStep makePredicate(BooleanExpr expr, InfinispanAggregation aggregation) {
        if (expr == null) {
            return this.predicateFactory.matchAll();
        }
        PredicateFinalStep predicateFinalStep = (PredicateFinalStep)expr.acceptVisitor((Visitor)this);
        if (aggregation == null || aggregation.propertyPath() == null || aggregation.propertyPath() instanceof CacheValueAggregationPropertyPath) {
            if (this.knn != null && !(expr instanceof KnnPredicate)) {
                throw log.booleanKnnPredicates();
            }
            return predicateFinalStep;
        }
        return (PredicateFinalStep)((BooleanPredicateClausesStep)this.predicateFactory.bool().must(predicateFinalStep)).must((PredicateFinalStep)this.predicateFactory.exists().field(aggregation.propertyPath().asStringPath()));
    }

    public PredicateFinalStep visit(FullTextOccurExpr fullTextOccurExpr) {
        PredicateFinalStep childPredicate = (PredicateFinalStep)fullTextOccurExpr.getChild().acceptVisitor((Visitor)this);
        switch (fullTextOccurExpr.getOccur()) {
            case SHOULD: {
                return (PredicateFinalStep)this.predicateFactory.bool().should(childPredicate);
            }
            case MUST: 
            case FILTER: {
                return (PredicateFinalStep)this.predicateFactory.bool().must(childPredicate);
            }
            case MUST_NOT: {
                return (PredicateFinalStep)this.predicateFactory.bool().mustNot(childPredicate);
            }
        }
        throw new IllegalArgumentException("Unknown boolean occur clause: " + String.valueOf(fullTextOccurExpr.getOccur()));
    }

    public PredicateFinalStep visit(FullTextBoostExpr fullTextBoostExpr) {
        BooleanExpr child = fullTextBoostExpr.getChild();
        float boost = fullTextBoostExpr.getBoost();
        if (child instanceof FullTextRegexpExpr) {
            FullTextRegexpExpr fullTextRegexpExpr = (FullTextRegexpExpr)child;
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
            return (PredicateFinalStep)this.predicateFactory.regexp().field(propertyValueExpr.getPropertyPath().asStringPath()).matching(fullTextRegexpExpr.getRegexp()).flags(new RegexpQueryFlag[]{RegexpQueryFlag.INTERVAL, RegexpQueryFlag.INTERSECTION, RegexpQueryFlag.ANY_STRING}).boost(boost);
        }
        PredicateFinalStep childPredicate = (PredicateFinalStep)child.acceptVisitor((Visitor)this);
        if (childPredicate instanceof PredicateScoreStep) {
            ((PredicateScoreStep)childPredicate).boost(boost);
        }
        return childPredicate;
    }

    private boolean isMultiTermText(PropertyPath<?> propertyPath, String text) {
        Analyzer analyzer = this.getAnalyzer(propertyPath);
        if (analyzer == null) {
            analyzer = new WhitespaceAnalyzer();
        }
        int terms = 0;
        try (TokenStream tokenStream = analyzer.tokenStream(propertyPath.asStringPathWithoutAlias(), (Reader)new StringReader(text));){
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken() && (posIncAtt.getPositionIncrement() <= 0 || ++terms <= 1)) {
            }
            tokenStream.end();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return terms > 1;
    }

    private Analyzer getAnalyzer(PropertyPath<?> propertyPath) {
        Optional indexFieldDescriptor = this.indexedEntity.indexManager().descriptor().field(propertyPath.asStringPath());
        if (!indexFieldDescriptor.isPresent()) {
            return null;
        }
        IndexFieldDescriptor fieldDescriptor = (IndexFieldDescriptor)indexFieldDescriptor.get();
        if (fieldDescriptor.isObjectField()) {
            return null;
        }
        IndexValueFieldDescriptor valueField = fieldDescriptor.toValueField();
        Optional analyzerName = valueField.type().analyzerName();
        if (!analyzerName.isPresent()) {
            return null;
        }
        LuceneBackend luceneBackend = (LuceneBackend)this.indexedEntity.indexManager().backend().unwrap(LuceneBackend.class);
        Optional analyzer = luceneBackend.analyzer((String)analyzerName.get());
        if (!analyzer.isPresent()) {
            return null;
        }
        return (Analyzer)analyzer.get();
    }

    public PredicateFinalStep visit(FullTextTermExpr fullTextTermExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextTermExpr.getChild();
        String text = fullTextTermExpr.getTerm(this.namedParameters);
        String absoluteFieldPath = propertyValueExpr.getPropertyPath().asStringPath();
        int asteriskPos = text.indexOf(42);
        int questionPos = text.indexOf(63);
        if (asteriskPos == -1 && questionPos == -1) {
            if (this.isMultiTermText(propertyValueExpr.getPropertyPath(), text)) {
                PhrasePredicateOptionsStep result = this.predicateFactory.phrase().field(absoluteFieldPath).matching(text);
                if (fullTextTermExpr.getFuzzySlop() != null) {
                    result.slop(fullTextTermExpr.getFuzzySlop().intValue());
                }
                return result;
            }
            MatchPredicateOptionsStep result = this.predicateFactory.match().field(absoluteFieldPath).matching((Object)text);
            if (fullTextTermExpr.getFuzzySlop() != null) {
                result.fuzzy(fullTextTermExpr.getFuzzySlop().intValue());
            }
            return result;
        }
        if (fullTextTermExpr.getFuzzySlop() != null) {
            throw Log.CONTAINER.getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(fullTextTermExpr.toQueryString());
        }
        if (questionPos == -1 && asteriskPos == text.length() - 1) {
            return ((SimpleQueryStringPredicateOptionsStep)((SimpleQueryStringPredicateFieldMoreStep)this.predicateFactory.simpleQueryString().field(absoluteFieldPath)).matching(text)).flags(new SimpleQueryFlag[]{SimpleQueryFlag.PREFIX});
        }
        return this.predicateFactory.wildcard().field(absoluteFieldPath).matching(text);
    }

    public PredicateFinalStep visit(FullTextRegexpExpr fullTextRegexpExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
        return this.predicateFactory.regexp().field(propertyValueExpr.getPropertyPath().asStringPath()).matching(fullTextRegexpExpr.getRegexp());
    }

    public PredicateFinalStep visit(FullTextRangeExpr fullTextRangeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRangeExpr.getChild();
        String absoluteFieldPath = propertyValueExpr.getPropertyPath().asStringPath();
        Object lower = fullTextRangeExpr.getLower();
        Object upper = fullTextRangeExpr.getUpper();
        boolean includeLower = fullTextRangeExpr.isIncludeLower();
        boolean includeUpper = fullTextRangeExpr.isIncludeUpper();
        if (lower == null && upper == null) {
            return this.predicateFactory.exists().field(absoluteFieldPath);
        }
        RangePredicateFieldMoreStep range = this.predicateFactory.range().field(absoluteFieldPath);
        return range.between(lower, includeLower ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED, upper, includeUpper ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED);
    }

    public PredicateFinalStep visit(KnnPredicate knnPredicate) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)knnPredicate.getChild();
        String absoluteFieldPath = propertyValueExpr.getPropertyPath().asStringPath();
        if (this.knn != null) {
            throw log.multipleKnnPredicates();
        }
        this.knn = knnPredicate.knn(this.namedParameters);
        if (this.knn == null) {
            this.knn = this.maxResults;
        }
        KnnPredicateVectorStep knnPredicateVector = this.predicateFactory.knn(this.knn.intValue()).field(absoluteFieldPath);
        KnnPredicateOptionsStep knnPredicateOptions = knnPredicate.floats() ? knnPredicateVector.matching(knnPredicate.floatsArray(this.namedParameters)) : knnPredicateVector.matching(knnPredicate.bytesArray(this.namedParameters));
        if (this.filteringClause != null) {
            PredicateFinalStep predicateFinalStep = (PredicateFinalStep)this.filteringClause.acceptVisitor((Visitor)this);
            knnPredicateOptions.filter(predicateFinalStep);
        }
        return knnPredicateOptions;
    }

    public PredicateFinalStep visit(SpatialWithinCircleExpr spatialWithinCircleExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)spatialWithinCircleExpr.getLeftChild();
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        ConstantValueExpr latValueExpr = (ConstantValueExpr)spatialWithinCircleExpr.getLatChild();
        ConstantValueExpr lonValueExpr = (ConstantValueExpr)spatialWithinCircleExpr.getLonChild();
        ConstantValueExpr radiusValueExpr = (ConstantValueExpr)spatialWithinCircleExpr.getRadiusChild();
        ConstantValueExpr unitValueExpr = spatialWithinCircleExpr.getUnitChild();
        Double latValue = (Double)latValueExpr.getConstantValueAs(Double.class, this.namedParameters);
        Double lonValue = (Double)lonValueExpr.getConstantValueAs(Double.class, this.namedParameters);
        Double radiusValue = (Double)radiusValueExpr.getConstantValueAs(Double.class, this.namedParameters);
        String unitValue = (String)((Object)unitValueExpr.getConstantValueAs(String.class, this.namedParameters));
        DistanceUnit distanceUnit = DistanceUnitHelper.distanceUnit(unitValue);
        return this.predicateFactory.spatial().within().field(path).circle(latValue.doubleValue(), lonValue.doubleValue(), radiusValue.doubleValue(), distanceUnit);
    }

    public PredicateFinalStep visit(SpatialWithinBoxExpr spatialWithinBoxExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)spatialWithinBoxExpr.getLeftChild();
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        ConstantValueExpr tlLatChild = (ConstantValueExpr)spatialWithinBoxExpr.getTlLatChild();
        ConstantValueExpr tlLonChild = (ConstantValueExpr)spatialWithinBoxExpr.getTlLonChild();
        ConstantValueExpr brLatChild = (ConstantValueExpr)spatialWithinBoxExpr.getBrLatChild();
        ConstantValueExpr brLonChild = (ConstantValueExpr)spatialWithinBoxExpr.getBrLonChild();
        Double tlLat = (Double)tlLatChild.getConstantValueAs(Double.class, this.namedParameters);
        Double tlLon = (Double)tlLonChild.getConstantValueAs(Double.class, this.namedParameters);
        Double brLat = (Double)brLatChild.getConstantValueAs(Double.class, this.namedParameters);
        Double brLon = (Double)brLonChild.getConstantValueAs(Double.class, this.namedParameters);
        return this.predicateFactory.spatial().within().field(path).boundingBox(tlLat.doubleValue(), tlLon.doubleValue(), brLat.doubleValue(), brLon.doubleValue());
    }

    public PredicateFinalStep visit(SpatialWithinPolygonExpr spatialWithinPolygonExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)spatialWithinPolygonExpr.getLeftChild();
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>(spatialWithinPolygonExpr.getVector().stream().map(c -> (String)((Object)c.getConstantValueAs(String.class, this.namedParameters))).map(s -> {
            String substring = s.substring(1, s.length() - 1);
            String[] split = substring.split(",");
            double lat = Double.parseDouble(split[0]);
            double lon = Double.parseDouble(split[1]);
            return GeoPoint.of((double)lat, (double)lon);
        }).toList());
        if (!geoPoints.isEmpty()) {
            geoPoints.add((GeoPoint)geoPoints.get(0));
        }
        return this.predicateFactory.spatial().within().field(path).polygon(GeoPolygon.of(geoPoints));
    }

    public PredicateFinalStep visit(NotExpr notExpr) {
        BooleanExpr childExpr = notExpr.getChild();
        if (childExpr instanceof IsNullExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)((IsNullExpr)childExpr).getChild();
            return this.predicateFactory.exists().field(propertyValueExpr.getPropertyPath().asStringPath());
        }
        PredicateFinalStep childPredicate = (PredicateFinalStep)childExpr.acceptVisitor((Visitor)this);
        return (PredicateFinalStep)this.predicateFactory.bool().mustNot(childPredicate);
    }

    public PredicateFinalStep visit(OrExpr orExpr) {
        BooleanPredicateClausesStep bool = this.predicateFactory.bool();
        for (BooleanExpr c : orExpr.getChildren()) {
            PredicateFinalStep clause = (PredicateFinalStep)c.acceptVisitor((Visitor)this);
            bool.should(clause);
        }
        return bool;
    }

    public PredicateFinalStep visit(AndExpr andExpr) {
        BooleanPredicateClausesStep bool = this.predicateFactory.bool();
        for (BooleanExpr c : andExpr.getChildren()) {
            PredicateFinalStep clause = (PredicateFinalStep)c.acceptVisitor((Visitor)this);
            bool.must(clause);
        }
        return bool;
    }

    public PredicateFinalStep visit(IsNullExpr isNullExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
        ExistsPredicateOptionsStep exists = this.predicateFactory.exists().field(propertyValueExpr.getPropertyPath().asStringPath());
        return (PredicateFinalStep)this.predicateFactory.bool().mustNot((PredicateFinalStep)exists);
    }

    public PredicateFinalStep visit(ComparisonExpr comparisonExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
        ConstantValueExpr constantValueExpr = (ConstantValueExpr)comparisonExpr.getRightChild();
        Comparable value = constantValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        switch (comparisonExpr.getComparisonType()) {
            case NOT_EQUAL: {
                return (PredicateFinalStep)this.predicateFactory.bool().mustNot(c -> c.match().field(path).matching((Object)value));
            }
            case EQUAL: {
                return this.predicateFactory.match().field(path).matching((Object)value);
            }
            case LESS: {
                return this.predicateFactory.range().field(path).lessThan((Object)value);
            }
            case LESS_OR_EQUAL: {
                return this.predicateFactory.range().field(path).atMost((Object)value);
            }
            case GREATER: {
                return this.predicateFactory.range().field(path).greaterThan((Object)value);
            }
            case GREATER_OR_EQUAL: {
                return this.predicateFactory.range().field(path).atLeast((Object)value);
            }
        }
        throw new IllegalStateException("Unexpected comparison type: " + String.valueOf(comparisonExpr.getComparisonType()));
    }

    public PredicateFinalStep visit(BetweenExpr betweenExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)betweenExpr.getLeftChild();
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        ConstantValueExpr fromValueExpr = (ConstantValueExpr)betweenExpr.getFromChild();
        ConstantValueExpr toValueExpr = (ConstantValueExpr)betweenExpr.getToChild();
        Comparable fromValue = fromValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        Comparable toValue = toValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        return this.predicateFactory.range().field(path).between((Object)fromValue, (Object)toValue);
    }

    public PredicateFinalStep visit(LikeExpr likeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
        StringBuilder lucenePattern = new StringBuilder(likeExpr.getPattern(this.namedParameters));
        boolean isEscaped = false;
        for (int i = 0; i < lucenePattern.length(); ++i) {
            char c = lucenePattern.charAt(i);
            if (!isEscaped && c == likeExpr.getEscapeChar()) {
                isEscaped = true;
                lucenePattern.deleteCharAt(i);
                continue;
            }
            if (isEscaped) {
                isEscaped = false;
            } else {
                if (c == '%') {
                    lucenePattern.setCharAt(i, '*');
                    continue;
                }
                if (c == '_') {
                    lucenePattern.setCharAt(i, '?');
                    continue;
                }
            }
            if (c != '?' && c != '*') continue;
            lucenePattern.insert(i, '\\');
            ++i;
        }
        String path = propertyValueExpr.getPropertyPath().asStringPath();
        return this.predicateFactory.wildcard().field(path).matching(lucenePattern.toString());
    }

    public PredicateFinalStep visit(ConstantBooleanExpr constantBooleanExpr) {
        return constantBooleanExpr.getValue() ? this.predicateFactory.matchAll() : (PredicateFinalStep)this.predicateFactory.bool().mustNot((PredicateFinalStep)this.predicateFactory.matchAll());
    }

    public PredicateFinalStep visit(ConstantValueExpr constantValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public PredicateFinalStep visit(PropertyValueExpr propertyValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public PredicateFinalStep visit(AggregationExpr aggregationExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public PredicateFinalStep visit(NestedExpr nestedExpr) {
        BooleanPredicateClausesStep bool = this.predicateFactory.bool();
        NestedPredicateClausesStep nested = this.predicateFactory.nested(nestedExpr.getNestedPath());
        for (BooleanExpr c : nestedExpr.getChildren()) {
            PredicateFinalStep clause = (PredicateFinalStep)c.acceptVisitor((Visitor)this);
            nested.add(clause);
        }
        bool.must((PredicateFinalStep)nested);
        return bool;
    }
}

