/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.EntityLoaded;
import org.infinispan.security.actions.SecurityActions;

abstract class BaseEntityLoader<E, T>
implements PojoSelectionEntityLoader<EntityLoaded<E>> {
    protected final AdvancedCache<Object, Object> cache;
    private final LocalQueryStatistics queryStatistics;

    BaseEntityLoader(AdvancedCache<Object, Object> cache, LocalQueryStatistics queryStatistics) {
        this.cache = Objects.requireNonNull(cache);
        this.queryStatistics = Objects.requireNonNull(queryStatistics);
    }

    public final List<EntityLoaded<E>> loadBlocking(List<?> identifiers, Deadline deadline) {
        assert (identifiers != null);
        if (identifiers.isEmpty()) {
            return List.of();
        }
        Map<Object, T> values = this.queryStatistics.isEnabled() ? this.loadEntriesMeasuringDuration(identifiers) : this.loadEntries(identifiers);
        ArrayList<EntityLoaded<EntityLoaded<E>>> result = new ArrayList<EntityLoaded<EntityLoaded<E>>>(identifiers.size());
        for (Object key : identifiers) {
            result.add(this.toEntityLoader(values.get(key)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, T> loadEntriesMeasuringDuration(List<?> keys) {
        TimeService timeService = SecurityActions.getCacheComponentRegistry(this.cache).getTimeService();
        long start = timeService.time();
        try {
            Map<Object, T> map = this.loadEntries(keys);
            return map;
        }
        finally {
            this.queryStatistics.entityLoaded(timeService.timeDuration(start, TimeUnit.NANOSECONDS));
        }
    }

    protected final E fromStorage(Object value) {
        assert (value != null);
        return (E)this.cache.getValueDataConversion().fromStorage(value);
    }

    abstract Map<Object, T> loadEntries(List<?> var1);

    abstract EntityLoaded<E> toEntityLoader(T var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntityLoader that = (BaseEntityLoader)o;
        return this.cache.equals(that.cache) && this.queryStatistics.equals(that.queryStatistics);
    }

    public int hashCode() {
        int result = this.cache.hashCode();
        result = 31 * result + this.queryStatistics.hashCode();
        return result;
    }
}

