/*
 *
 *  JBoss, Home of Professional Open Source.
 *  Copyright 2013, Red Hat, Inc., and individual contributors
 *  as indicated by the @author tags. See the copyright.txt file in the
 *  distribution for a full listing of individual contributors.
 *
 *  This is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1 of
 *  the License, or (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this software; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 *  02110-1301 USA, or see the FSF site: http://www.fsf.org.
 * /
 */

package org.wildfly.extension.undertow.session;

import org.jboss.as.clustering.web.OutgoingDistributableSessionData;

/**
 * Abstract base class for a session snapshot manager.
 *
 * @author Thomas Peuss <jboss@peuss.de>
 */
public abstract class SnapshotManager {
    // The manager the snapshot manager should use
    private final SessionManager manager;

    // The context-path
    private final String contextPath;

    public SnapshotManager(SessionManager manager, String path) {
        this.manager = manager;
        contextPath = path;
    }

    /**
     * Tell the snapshot manager which session was modified and must be replicated
     */
    public abstract void snapshot(ClusteredSession<? extends OutgoingDistributableSessionData> session);

    /**
     * Start the snapshot manager
     */
    public abstract void start();

    /**
     * Stop the snapshot manager
     */
    public abstract void stop();

    protected String getContextPath() {
        return contextPath;
    }


    protected SessionManager getManager() {
        return manager;
    }

}
