/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import org.sonatype.guice.bean.locators.BeanCache;
import org.sonatype.guice.bean.locators.RankedSequence;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;
import org.sonatype.guice.bean.reflect.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RankedBindings<T>
implements Iterable<Binding<T>>,
BindingSubscriber<T> {
    final transient RankedSequence<Binding<T>> bindings = new RankedSequence();
    final transient TypeLiteral<T> type;
    final transient RankedSequence<BindingPublisher> pendingPublishers;
    final Collection<BeanCache<?, T>> cachedBeans = Weak.elements();
    volatile int topRank = Integer.MAX_VALUE;

    RankedBindings(TypeLiteral<T> type, RankedSequence<BindingPublisher> publishers) {
        this.type = type;
        this.pendingPublishers = new RankedSequence<BindingPublisher>(publishers);
    }

    @Override
    public TypeLiteral<T> type() {
        return this.type;
    }

    @Override
    public void add(Binding<T> binding, int rank) {
        this.bindings.insert(binding, rank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Binding<T> binding) {
        if (this.bindings.removeThis(binding)) {
            Collection<BeanCache<?, T>> collection = this.cachedBeans;
            synchronized (collection) {
                for (BeanCache<?, T> beans : this.cachedBeans) {
                    beans.remove(binding);
                }
            }
        }
    }

    @Override
    public Iterable<Binding<T>> bindings() {
        return this.bindings.snapshot();
    }

    public Itr iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Q extends Annotation> BeanCache<Q, T> newBeanCache() {
        BeanCache beans = new BeanCache();
        Collection<BeanCache<?, T>> collection = this.cachedBeans;
        synchronized (collection) {
            this.cachedBeans.add(beans);
        }
        return beans;
    }

    void add(BindingPublisher publisher, int rank) {
        this.pendingPublishers.insert(publisher, rank);
        if (rank > this.topRank) {
            this.topRank = rank;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(BindingPublisher publisher) {
        RankedSequence<BindingPublisher> rankedSequence = this.pendingPublishers;
        synchronized (rankedSequence) {
            if (!this.pendingPublishers.remove(publisher)) {
                publisher.unsubscribe(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Itr
    implements Iterator<Binding<T>> {
        private final RankedSequence.Itr itr;

        Itr() {
            this.itr = RankedBindings.this.bindings.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            int rank = RankedBindings.this.topRank;
            if (rank > Integer.MIN_VALUE && rank > this.itr.peekNextRank()) {
                RankedSequence<BindingPublisher> rankedSequence = RankedBindings.this.pendingPublishers;
                synchronized (rankedSequence) {
                    while ((rank = RankedBindings.this.pendingPublishers.topRank()) > Integer.MIN_VALUE && rank > this.itr.peekNextRank()) {
                        RankedBindings.this.pendingPublishers.poll().subscribe(RankedBindings.this);
                    }
                    RankedBindings.this.topRank = rank;
                }
            }
            return this.itr.hasNext();
        }

        @Override
        public Binding<T> next() {
            return (Binding)this.itr.next();
        }

        public int rank() {
            return this.itr.rank();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

