/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleExecutor.class)
public class DefaultLifecycleExecutor
implements LifecycleExecutor {
    @Requirement
    private LifeCyclePluginAnalyzer lifeCyclePluginAnalyzer;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Requirement
    private LifecycleExecutionPlanCalculator lifecycleExecutionPlanCalculator;
    @Requirement
    private MojoExecutor mojoExecutor;
    @Requirement
    private LifecycleStarter lifecycleStarter;
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;

    @Override
    public void execute(MavenSession session) {
        this.lifecycleStarter.execute(session);
    }

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        return this.lifeCyclePluginAnalyzer.getPluginsBoundByDefaultToAllLifecycles(packaging);
    }

    @Deprecated
    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        return this.defaultLifeCycles.getPhaseToLifecycleMap();
    }

    MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project, String invokedVia, boolean canUsePrefix, boolean isOptionalMojo) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        return this.mojoDescriptorCreator.getMojoDescriptor(task, session, project);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, boolean setup, String ... tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginManagerException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        List<TaskSegment> taskSegments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(session, Arrays.asList(tasks));
        TaskSegment mergedSegment = new TaskSegment(false);
        for (TaskSegment taskSegment : taskSegments) {
            mergedSegment.getTasks().addAll(taskSegment.getTasks());
        }
        return this.lifecycleExecutionPlanCalculator.calculateExecutionPlan(session, session.getCurrentProject(), mergedSegment.getTasks(), setup);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, String ... tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginManagerException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        return this.calculateExecutionPlan(session, true, tasks);
    }

    @Override
    public void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.lifecycleExecutionPlanCalculator.calculateForkedExecutions(mojoExecution, session);
    }

    @Override
    public List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException {
        return this.mojoExecutor.executeForkedExecutions(mojoExecution, session, new ProjectIndex(session.getProjects()));
    }
}

