/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrencyDependencyGraph {
    private final ProjectBuildList projectBuilds;
    private final ProjectDependencyGraph projectDependencyGraph;
    private final HashSet<MavenProject> finishedProjects = new HashSet();

    public ConcurrencyDependencyGraph(ProjectBuildList projectBuilds, ProjectDependencyGraph projectDependencyGraph) {
        this.projectDependencyGraph = projectDependencyGraph;
        this.projectBuilds = projectBuilds;
    }

    public int getNumberOfBuilds() {
        return this.projectBuilds.size();
    }

    public List<MavenProject> getRootSchedulableBuilds() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (ProjectSegment projectBuild : this.projectBuilds) {
            if (this.projectDependencyGraph.getUpstreamProjects(projectBuild.getProject(), false).size() != 0) continue;
            result.add(projectBuild.getProject());
        }
        return result;
    }

    public List<MavenProject> markAsFinished(MavenProject mavenProject) {
        this.finishedProjects.add(mavenProject);
        return this.getSchedulableNewProcesses(mavenProject);
    }

    private List<MavenProject> getSchedulableNewProcesses(MavenProject finishedProject) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject dependentProject : this.projectDependencyGraph.getDownstreamProjects(finishedProject, false)) {
            List<MavenProject> upstreamProjects = this.projectDependencyGraph.getUpstreamProjects(dependentProject, false);
            if (!this.finishedProjects.containsAll(upstreamProjects)) continue;
            result.add(dependentProject);
        }
        return result;
    }

    public ProjectBuildList getProjectBuilds() {
        return this.projectBuilds;
    }
}

