/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadata;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.PropertyReplacingBeansXmlParser;
import org.jboss.as.weld.deployment.UrlScanner;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.services.bootstrap.WeldJaxwsInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.xml.BeansXmlParser;

public class ExternalBeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            return;
        }
        HashSet<String> componentClassNames = new HashSet<String>();
        String beanArchiveIdPrefix = deploymentUnit.getName() + ".external.";
        ArrayList<DeploymentUnit> deploymentUnits = new ArrayList<DeploymentUnit>();
        deploymentUnits.add(deploymentUnit);
        deploymentUnits.addAll(deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS));
        PropertyReplacingBeansXmlParser parser = new PropertyReplacingBeansXmlParser(deploymentUnit);
        HashSet<URL> existing = new HashSet<URL>();
        for (DeploymentUnit deployment : deploymentUnits) {
            try {
                ExplicitBeanArchiveMetadataContainer weldDeploymentMetadata = (ExplicitBeanArchiveMetadataContainer)deployment.getAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
                if (weldDeploymentMetadata != null) {
                    for (ExplicitBeanArchiveMetadata md : weldDeploymentMetadata.getBeanArchiveMetadata().values()) {
                        existing.add(md.getBeansXmlFile().toURL());
                        if (md.getAdditionalBeansXmlFile() == null) continue;
                        existing.add(md.getAdditionalBeansXmlFile().toURL());
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            EEModuleDescription moduleDesc = (EEModuleDescription)deployment.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            if (moduleDesc == null) continue;
            for (ComponentDescription component : moduleDesc.getComponentDescriptions()) {
                componentClassNames.add(component.getComponentClassName());
            }
        }
        for (DeploymentUnit deployment : deploymentUnits) {
            Module module = (Module)deployment.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            if (module == null) {
                return;
            }
            for (DependencySpec dep : module.getDependencies()) {
                URL url;
                Module dependency = this.loadModuleDependency(dep);
                if (dependency == null || (url = this.findExportedLocalBeansXml(dependency)) == null || existing.contains(url) || url.toString().contains("jsf-impl-2.2") || url.toString().contains("resteasy-cdi")) continue;
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Found external beans.xml: %s", url.toString());
                BeansXml beansXml = this.parseBeansXml(url, parser, deploymentUnit);
                UrlScanner urlScanner = new UrlScanner();
                ArrayList<String> discoveredClasses = new ArrayList<String>();
                if (!urlScanner.handleBeansXml(url, discoveredClasses)) continue;
                discoveredClasses.removeAll(componentClassNames);
                BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(new HashSet<String>(discoveredClasses), beansXml, dependency, beanArchiveIdPrefix + url.toExternalForm(), BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL);
                WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered(bda);
                WeldJpaInjectionServices jpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit);
                WeldJaxwsInjectionServices jaxwsInjectionServices = new WeldJaxwsInjectionServices(deploymentUnit);
                bda.getServices().add(JpaInjectionServices.class, (Service)jpaInjectionServices);
                bda.getServices().add(JaxwsInjectionServices.class, (Service)jaxwsInjectionServices);
                deploymentUnit.addToAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES, (Object)bda);
            }
        }
    }

    private URL findExportedLocalBeansXml(Module dependencyModule) {
        Enumeration exported = dependencyModule.getExportedResources(META_INF_BEANS_XML);
        if (exported.hasMoreElements()) {
            URL local;
            HashSet exportedSet = new HashSet(Collections.list(exported));
            List locals = dependencyModule.getClassLoader().loadResourceLocal(META_INF_BEANS_XML);
            if (!locals.isEmpty() && exportedSet.contains(local = ((Resource)locals.iterator().next()).getURL())) {
                return local;
            }
        }
        return null;
    }

    private Module loadModuleDependency(DependencySpec dep) {
        ModuleDependencySpec dependency;
        ModuleLoader loader;
        if (dep instanceof ModuleDependencySpec && (loader = (dependency = (ModuleDependencySpec)dep).getModuleLoader()) != null) {
            try {
                return dependency.getModuleLoader().loadModule(dependency.getIdentifier());
            }
            catch (ModuleLoadException e) {
                return null;
            }
        }
        return null;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BeansXml parseBeansXml(URL beansXmlFile, BeansXmlParser parser, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return parser.parse(beansXmlFile);
    }
}

