/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.wildfly.clustering.web.infinispan.session.CacheMutator;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionAttributes;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final Set<String> attributes;
    private final Cache<SessionAttributeCacheKey, V> cache;
    private final CacheInvoker invoker;
    private final SessionAttributeMarshaller<Object, V> marshaller;

    public FineSessionAttributes(String id, Set<String> attributes, Cache<SessionAttributeCacheKey, V> attributeCache, CacheInvoker invoker, SessionAttributeMarshaller<Object, V> marshaller) {
        super(id, attributes, attributeCache, invoker, marshaller);
        this.attributes = attributes;
        this.cache = attributeCache;
        this.invoker = invoker;
        this.marshaller = marshaller;
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name) ? this.marshaller.read(this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)this.createKey(name)), new Flag[]{Flag.SKIP_LOCKING})) : null;
    }

    public Object setAttribute(String name, Object attribute) {
        Flag[] flagArray;
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        final SessionAttributeCacheKey key = this.createKey(name);
        final V value = this.marshaller.write(attribute);
        CacheInvoker.Operation operation = new CacheInvoker.Operation<SessionAttributeCacheKey, V, V>(){

            public V invoke(Cache<SessionAttributeCacheKey, V> cache) {
                return cache.put((Object)key, value);
            }
        };
        if (this.attributes.add(name)) {
            Flag[] flagArray2 = new Flag[2];
            flagArray2[0] = Flag.IGNORE_RETURN_VALUES;
            flagArray = flagArray2;
            flagArray2[1] = Flag.SKIP_LOCKING;
        } else {
            Flag[] flagArray3 = new Flag[1];
            flagArray = flagArray3;
            flagArray3[0] = Flag.SKIP_LOCKING;
        }
        return this.marshaller.read(this.invoker.invoke(this.cache, operation, flagArray));
    }

    @Override
    public Object getAttribute(String name) {
        SessionAttributeCacheKey key = this.createKey(name);
        Object value = this.getAttributeValue(key);
        if (value == null) {
            return null;
        }
        Object attribute = this.marshaller.read(value);
        if (CacheMutator.isMutable(attribute)) {
            new CacheMutator<SessionAttributeCacheKey, V>(this.cache, this.invoker, key, value, Flag.SKIP_LOCKING).mutate();
        }
        return attribute;
    }
}

