/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.ServiceName;

final class PackageUtils {
    private PackageUtils() {
    }

    static ServiceName getEndpointConfigServiceName(String configName) {
        return WSServices.ENDPOINT_CONFIG_SERVICE.append(new String[]{configName});
    }

    static ServiceName getClientConfigServiceName(String configName) {
        return WSServices.CLIENT_CONFIG_SERVICE.append(new String[]{configName});
    }

    static ServiceName getConfigServiceName(String configType, String configName) {
        return "endpoint-config".equals(configType) ? PackageUtils.getEndpointConfigServiceName(configName) : PackageUtils.getClientConfigServiceName(configName);
    }

    static ServiceName getHandlerChainServiceName(String configType, String configName, String handlerChainId) {
        return PackageUtils.getHandlerChainServiceName(PackageUtils.getConfigServiceName(configType, configName), handlerChainId);
    }

    static ServiceName getHandlerChainServiceName(ServiceName configServiceName, String handlerChainId) {
        return configServiceName.append(new String[]{"handler-chain"}).append(new String[]{handlerChainId});
    }

    static ServiceName getHandlerServiceName(ServiceName handlerChainServiceName, String handlerName) {
        return handlerChainServiceName.append(new String[]{"handler"}).append(new String[]{handlerName});
    }

    static ServiceName getPropertyServiceName(ServiceName configServiceName, String propertyName) {
        return configServiceName.append(new String[]{"property"}).append(new String[]{propertyName});
    }
}

