/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Evictor;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbMessages;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;

public class InfinispanBeanFactory<G, I, T>
implements BeanFactory<G, I, T> {
    private final String beanName;
    private final BeanGroupFactory<G, I, T> groupFactory;
    private final Cache<BeanKey<I>, BeanEntry<G>> cache;
    private final CacheInvoker invoker;
    private final Time timeout;
    private final PassivationListener<T> listener;

    public InfinispanBeanFactory(String beanName, BeanGroupFactory<G, I, T> groupFactory, Cache<BeanKey<I>, BeanEntry<G>> beanCache, CacheInvoker invoker, Time timeout, PassivationListener<T> listener) {
        this.beanName = beanName;
        this.groupFactory = groupFactory;
        this.cache = beanCache;
        this.invoker = invoker;
        this.timeout = timeout;
        this.listener = listener;
    }

    @Override
    public BeanKey<I> createKey(I id) {
        return new InfinispanBeanKey<I>(this.beanName, id);
    }

    @Override
    public Bean<G, I, T> createBean(I id, BeanEntry<G> entry) {
        G groupId = entry.getGroupId();
        BeanGroupEntry groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
        if (groupEntry == null) {
            throw InfinispanEjbMessages.MESSAGES.invalidBeanGroup(id, groupId);
        }
        BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        Mutator mutator = entry.getLastAccessedTime() == null ? Mutator.PASSIVE : new BeanMutator<G, I>(this.invoker, this.cache, this.createKey(id), entry);
        return new InfinispanBean<G, I, T>(id, entry, group, mutator, this, this.timeout, this.listener);
    }

    public BeanEntry<G> findValue(I id) {
        return (BeanEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Locator.FindOperation(this.createKey(id)), new Flag[0]);
    }

    @Override
    public BeanEntry<G> createValue(I id, G groupId) {
        InfinispanBeanEntry<G> entry = new InfinispanBeanEntry<G>(groupId);
        InfinispanBeanEntry<G> existing = (InfinispanBeanEntry<G>)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Creator.CreateOperation(this.createKey(id), entry), new Flag[0]);
        return existing != null ? existing : entry;
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        BeanEntry entry = (BeanEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Remover.RemoveOperation(this.createKey(id)), new Flag[0]);
        if (entry != null) {
            Object groupId = entry.getGroupId();
            try (BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.findValue(groupId));){
                T bean = group.removeBean(id);
                if (listener != null) {
                    listener.removed(bean);
                }
            }
        }
    }

    public void evict(I id) {
        BeanKey<I> key = this.createKey(id);
        BeanEntry entry = (BeanEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Locator.FindOperation(key), new Flag[0]);
        if (entry != null) {
            if (!((Boolean)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Evictor.PreLockedEvictOperation(key), new Flag[0])).booleanValue()) {
                InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBean(id);
            }
            this.groupFactory.evict(entry.getGroupId());
        }
    }

    private static class BeanMutator<G, I>
    implements Mutator {
        private final CacheInvoker invoker;
        private final Cache<BeanKey<I>, BeanEntry<G>> cache;
        private final BeanKey<I> key;
        private final BeanEntry<G> entry;

        BeanMutator(CacheInvoker invoker, Cache<BeanKey<I>, BeanEntry<G>> cache, BeanKey<I> key, BeanEntry<G> entry) {
            this.invoker = invoker;
            this.cache = cache;
            this.key = key;
            this.entry = entry;
        }

        public void mutate() {
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Mutator.MutateOperation(this.key, this.entry), new Flag[]{Flag.IGNORE_RETURN_VALUES});
        }
    }
}

