/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.impl.WireFormat;

public class ProtobufParser {
    public void parse(TagHandler tagHandler, Descriptors.Descriptor messageDescriptor, byte[] input) throws IOException {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        CodedInputStream in = CodedInputStream.newInstance((InputStream)bais);
        this.parse(tagHandler, messageDescriptor, in);
    }

    private void parse(TagHandler tagHandler, Descriptors.Descriptor messageDescriptor, CodedInputStream in) throws IOException {
        int tag;
        tagHandler.onStart();
        block21: while ((tag = in.readTag()) != 0) {
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            int wireType = WireFormat.getTagWireType(tag);
            Descriptors.FieldDescriptor fd = messageDescriptor != null ? messageDescriptor.findFieldByNumber(fieldNumber) : null;
            switch (wireType) {
                case 2: {
                    if (fd == null) {
                        byte[] value = in.readBytes().toByteArray();
                        tagHandler.onTag(fieldNumber, null, Descriptors.FieldDescriptor.Type.BYTES, Descriptors.FieldDescriptor.JavaType.BYTE_STRING, value);
                        continue block21;
                    }
                    if (fd.getType() == Descriptors.FieldDescriptor.Type.STRING) {
                        String value = in.readString();
                        tagHandler.onTag(fieldNumber, fd.getName(), fd.getType(), fd.getJavaType(), value);
                        continue block21;
                    }
                    if (fd.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                        byte[] value = in.readBytes().toByteArray();
                        tagHandler.onTag(fieldNumber, fd.getName(), fd.getType(), fd.getJavaType(), value);
                        continue block21;
                    }
                    if (fd.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) continue block21;
                    int length = in.readRawVarint32();
                    int oldLimit = in.pushLimit(length);
                    tagHandler.onStartNested(fieldNumber, fd.getName(), fd.getMessageType());
                    this.parse(tagHandler, fd.getMessageType(), in);
                    tagHandler.onEndNested(fieldNumber, fd.getName(), fd.getMessageType());
                    in.checkLastTagWas(0);
                    in.popLimit(oldLimit);
                    continue block21;
                }
                case 3: {
                    if (fd != null) {
                        tagHandler.onStartNested(fieldNumber, null, null);
                        this.parse(tagHandler, null, in);
                        in.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                        tagHandler.onEndNested(fieldNumber, null, null);
                        continue block21;
                    }
                    tagHandler.onStartNested(fieldNumber, fd.getName(), fd.getMessageType());
                    this.parse(tagHandler, fd.getMessageType(), in);
                    in.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                    tagHandler.onEndNested(fieldNumber, fd.getName(), fd.getMessageType());
                    continue block21;
                }
                case 0: 
                case 1: 
                case 5: {
                    Constable value;
                    if (fd == null) {
                        if (wireType == 5) {
                            tagHandler.onTag(fieldNumber, null, null, null, in.readFixed32());
                            continue block21;
                        }
                        if (wireType == 1) {
                            tagHandler.onTag(fieldNumber, null, null, null, in.readFixed64());
                            continue block21;
                        }
                        if (wireType != 0) continue block21;
                        tagHandler.onTag(fieldNumber, null, null, null, in.readRawVarint64());
                        continue block21;
                    }
                    switch (fd.getType()) {
                        case DOUBLE: {
                            value = in.readDouble();
                            break;
                        }
                        case FLOAT: {
                            value = Float.valueOf(in.readFloat());
                            break;
                        }
                        case BOOL: {
                            value = Boolean.valueOf(in.readBool());
                            break;
                        }
                        case INT32: {
                            value = in.readInt32();
                            break;
                        }
                        case SFIXED32: {
                            value = in.readSFixed32();
                            break;
                        }
                        case FIXED32: {
                            value = in.readFixed32();
                            break;
                        }
                        case UINT32: {
                            value = in.readUInt32();
                            break;
                        }
                        case SINT32: {
                            value = in.readSInt32();
                            break;
                        }
                        case INT64: {
                            value = in.readInt64();
                            break;
                        }
                        case UINT64: {
                            value = in.readUInt64();
                            break;
                        }
                        case FIXED64: {
                            value = in.readFixed64();
                            break;
                        }
                        case SFIXED64: {
                            value = in.readSFixed64();
                            break;
                        }
                        case SINT64: {
                            value = in.readSInt64();
                            break;
                        }
                        case ENUM: {
                            value = in.readEnum();
                            break;
                        }
                        default: {
                            throw new IOException("Unexpected field type : " + fd.getType());
                        }
                    }
                    tagHandler.onTag(fieldNumber, fd.getName(), fd.getType(), fd.getJavaType(), value);
                    continue block21;
                }
            }
            throw new IOException("Found tag with invalid wire type : " + tag);
        }
        tagHandler.onEnd();
    }
}

