/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.impl.ReadMessageContext;
import org.infinispan.protostream.impl.WireFormat;

public final class ProtoStreamReaderImpl
implements MessageMarshaller.ProtoStreamReader {
    private final SerializationContext ctx;
    private static final EnumSet<Descriptors.FieldDescriptor.Type> primitiveTypes = EnumSet.of(Descriptors.FieldDescriptor.Type.DOUBLE, new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.FLOAT, Descriptors.FieldDescriptor.Type.INT64, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.INT32, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.FIXED32, Descriptors.FieldDescriptor.Type.BOOL, Descriptors.FieldDescriptor.Type.STRING, Descriptors.FieldDescriptor.Type.BYTES, Descriptors.FieldDescriptor.Type.UINT32, Descriptors.FieldDescriptor.Type.SFIXED32, Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.SINT32, Descriptors.FieldDescriptor.Type.SINT64});
    private ReadMessageContext messageContext;

    public ProtoStreamReaderImpl(SerializationContext ctx) {
        this.ctx = ctx;
    }

    public <A> A read(CodedInputStream in, Class<A> clazz) throws IOException {
        if (MessageLite.class.isAssignableFrom(clazz)) {
            try {
                Parser parser = (Parser)clazz.getDeclaredField("PARSER").get(null);
                return (A)parser.parseFrom(this.messageContext.in);
            }
            catch (NoSuchFieldException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
        BaseMarshaller<A> marshaller = this.ctx.getMarshaller(clazz);
        Descriptors.Descriptor messageDescriptor = this.ctx.getMessageDescriptor(marshaller.getTypeName());
        this.resetContext();
        this.enterContext(null, messageDescriptor, in);
        Object a = marshaller instanceof MessageMarshaller ? ((MessageMarshaller)marshaller).readFrom(this) : ((RawProtobufMarshaller)marshaller).readFrom(this.ctx, in);
        this.exitContext();
        return (A)a;
    }

    public <A> A read(CodedInputStream in, MessageMarshaller<A> marshaller) throws IOException {
        Descriptors.Descriptor messageDescriptor = this.ctx.getMessageDescriptor(marshaller.getTypeName());
        this.resetContext();
        this.enterContext(null, messageDescriptor, in);
        A a = marshaller.readFrom(this);
        this.exitContext();
        return a;
    }

    private void resetContext() {
        this.messageContext = null;
    }

    private void enterContext(String fieldName, Descriptors.Descriptor messageDescriptor, CodedInputStream in) {
        this.messageContext = new ReadMessageContext(this.messageContext, fieldName, messageDescriptor, in);
    }

    private void exitContext() {
        for (Descriptors.FieldDescriptor fd : this.messageContext.getFieldDescriptors().values()) {
            if (!fd.isRequired() || this.messageContext.getSeenFields().contains(fd.getNumber())) continue;
            throw new IllegalStateException("Field " + fd.getName() + " is declared as required but was never read by the MessageMarshaller");
        }
        if (this.messageContext.getFieldDescriptors().size() != this.messageContext.getSeenFields().size()) {
            // empty if block
        }
        this.messageContext = (ReadMessageContext)this.messageContext.getParentContext();
    }

    private Object readPrimitive(String fieldName, Descriptors.FieldDescriptor.JavaType javaType) throws IOException {
        int tag;
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM || fd.getType() == Descriptors.FieldDescriptor.Type.GROUP || fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            throw new IllegalArgumentException("Declared field type is not a primitive : " + fd.getName());
        }
        if (fd.getJavaType() != javaType) {
            throw new IllegalArgumentException("Declared field type is not of the expected type : " + fd.getName());
        }
        this.checkNonRepeatedField(fd);
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getLiteType().getWireType());
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            if (javaType == Descriptors.FieldDescriptor.JavaType.STRING) {
                o = ((ByteString)o).toStringUtf8();
            }
            return o;
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                switch (fd.getType()) {
                    case DOUBLE: {
                        return this.messageContext.in.readDouble();
                    }
                    case FLOAT: {
                        return Float.valueOf(this.messageContext.in.readFloat());
                    }
                    case BOOL: {
                        return this.messageContext.in.readBool();
                    }
                    case STRING: {
                        return this.messageContext.in.readString();
                    }
                    case BYTES: {
                        return this.messageContext.in.readBytes().toByteArray();
                    }
                    case INT32: {
                        return this.messageContext.in.readInt32();
                    }
                    case SFIXED32: {
                        return this.messageContext.in.readSFixed32();
                    }
                    case FIXED32: {
                        return this.messageContext.in.readFixed32();
                    }
                    case UINT32: {
                        return this.messageContext.in.readUInt32();
                    }
                    case SINT32: {
                        return this.messageContext.in.readSInt32();
                    }
                    case INT64: {
                        return this.messageContext.in.readInt64();
                    }
                    case UINT64: {
                        return this.messageContext.in.readUInt64();
                    }
                    case FIXED64: {
                        return this.messageContext.in.readFixed64();
                    }
                    case SFIXED64: {
                        return this.messageContext.in.readSFixed64();
                    }
                    case SINT64: {
                        return this.messageContext.in.readSInt64();
                    }
                }
                throw new IOException("Unexpected field type : " + fd.getType());
            }
            this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
        }
        if (fd.isRequired()) {
            throw new IllegalStateException("Field " + fd.getName() + " is required but is not present in the stream");
        }
        if (fd.hasDefaultValue()) {
            return fd.getDefaultValue();
        }
        return null;
    }

    @Override
    public Integer readInt(String fieldName) throws IOException {
        Object o = this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.INT);
        if (o == null) {
            return null;
        }
        return o instanceof Integer ? ((Integer)o).intValue() : ((Number)o).intValue();
    }

    @Override
    public Long readLong(String fieldName) throws IOException {
        return (Long)this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.LONG);
    }

    @Override
    public Float readFloat(String fieldName) throws IOException {
        return (Float)this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.FLOAT);
    }

    @Override
    public Double readDouble(String fieldName) throws IOException {
        return (Double)this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.DOUBLE);
    }

    @Override
    public Boolean readBoolean(String fieldName) throws IOException {
        return (Boolean)this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.BOOLEAN);
    }

    @Override
    public String readString(String fieldName) throws IOException {
        return (String)this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.STRING);
    }

    @Override
    public byte[] readBytes(String fieldName) throws IOException {
        return (byte[])this.readPrimitive(fieldName, Descriptors.FieldDescriptor.JavaType.BYTE_STRING);
    }

    @Override
    public <A> A readObject(String fieldName, Class<? extends A> clazz) throws IOException {
        int tag;
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkNonRepeatedField(fd);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            if (ProtocolMessageEnum.class.isAssignableFrom(clazz)) {
                return this.readProtocolMessageEnum(fd, clazz);
            }
            return this.readEnum(fd, clazz);
        }
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getLiteType().getWireType());
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            ByteString byteString = (ByteString)o;
            CodedInputStream codedInputStream = byteString.newCodedInput();
            return this.readObject(fd, clazz, codedInputStream, byteString.size());
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                return this.readObject(fd, clazz, this.messageContext.in, -1);
            }
            this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
        }
        return null;
    }

    private <A extends ProtocolMessageEnum> A readProtocolMessageEnum(Descriptors.FieldDescriptor fd, Class<A> clazz) throws IOException {
        int enumValue;
        assert (fd.getLiteType().getWireType() == 0);
        int expectedTag = WireFormat.makeTag(fd.getNumber(), 0);
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            enumValue = ((Long)o).intValue();
        } else {
            while (true) {
                int tag;
                if ((tag = this.messageContext.in.readTag()) == 0) {
                    return null;
                }
                if (tag == expectedTag) {
                    enumValue = this.messageContext.in.readEnum();
                    break;
                }
                this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
            }
        }
        A decoded = this.decodeProtocolMessageEnum(clazz, enumValue);
        if (decoded == null) {
            this.messageContext.unknownFieldSet.mergeVarintField(expectedTag, enumValue);
        }
        return decoded;
    }

    private <A extends ProtocolMessageEnum> A decodeProtocolMessageEnum(Class<A> clazz, int enumValue) throws IOException {
        try {
            Method valueOf = clazz.getDeclaredMethod("valueOf", Integer.TYPE);
            return (A)((ProtocolMessageEnum)valueOf.invoke(null, enumValue));
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    private <A extends Enum<A>> A readEnum(Descriptors.FieldDescriptor fd, Class<A> clazz) throws IOException {
        int enumValue;
        assert (fd.getLiteType().getWireType() == 0);
        int expectedTag = WireFormat.makeTag(fd.getNumber(), 0);
        Object o = this.messageContext.unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            enumValue = ((Long)o).intValue();
        } else {
            while (true) {
                int tag;
                if ((tag = this.messageContext.in.readTag()) == 0) {
                    return null;
                }
                if (tag == expectedTag) {
                    enumValue = this.messageContext.in.readEnum();
                    break;
                }
                this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
            }
        }
        EnumMarshaller enumMarshaller = (EnumMarshaller)this.ctx.getMarshaller(clazz);
        Object decoded = enumMarshaller.decode(enumValue);
        if (decoded == null) {
            this.messageContext.unknownFieldSet.mergeVarintField(expectedTag, enumValue);
        }
        return (A)decoded;
    }

    private <A> A readObject(Descriptors.FieldDescriptor fd, Class<A> clazz, CodedInputStream in, int length) throws IOException {
        A a;
        BaseMarshaller<A> marshaller = this.ctx.getMarshaller(clazz);
        this.enterContext(fd.getName(), fd.getMessageType(), in);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            a = this.unmarshall(marshaller, in);
            in.checkLastTagWas(WireFormat.makeTag(fd.getNumber(), 4));
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            if (length < 0) {
                length = in.readRawVarint32();
            }
            int oldLimit = in.pushLimit(length);
            a = this.unmarshall(marshaller, in);
            in.checkLastTagWas(0);
            in.popLimit(oldLimit);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fd.getName());
        }
        this.exitContext();
        return a;
    }

    private <A> A unmarshall(BaseMarshaller<A> marshaller, CodedInputStream in) throws IOException {
        Object a = marshaller instanceof MessageMarshaller ? ((MessageMarshaller)marshaller).readFrom(this) : ((RawProtobufMarshaller)marshaller).readFrom(this.ctx, in);
        this.messageContext.unknownFieldSet.mergeFrom(this.messageContext.in);
        if (a instanceof Message && !this.messageContext.unknownFieldSet.isEmpty()) {
            ((Message)a).setUnknownFieldSet(this.messageContext.unknownFieldSet);
        }
        return (A)a;
    }

    @Override
    public <A, C extends Collection<? super A>> C readCollection(String fieldName, C collection, Class<? extends A> clazz) throws IOException {
        int tag;
        Object o;
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkRepeatedField(fd);
        if (primitiveTypes.contains(fd.getType())) {
            this.readPrimitiveCollection(fd, collection, clazz);
            return collection;
        }
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getLiteType().getWireType());
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            ByteString byteString = (ByteString)o;
            CodedInputStream codedInputStream = byteString.newCodedInput();
            collection.add(this.readObject(fd, clazz, codedInputStream, byteString.size()));
        }
        while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                collection.add(this.readObject(fd, clazz, this.messageContext.in, -1));
                continue;
            }
            this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
        }
        return collection;
    }

    private void readPrimitiveCollection(Descriptors.FieldDescriptor fd, Collection<? super Object> collection, Class clazz) throws IOException {
        int tag;
        Object o;
        int expectedTag = WireFormat.makeTag(fd.getNumber(), fd.getLiteType().getWireType());
        while ((o = this.messageContext.unknownFieldSet.consumeTag(expectedTag)) != null) {
            collection.add(o);
        }
        block18: while ((tag = this.messageContext.in.readTag()) != 0) {
            if (tag == expectedTag) {
                switch (fd.getType()) {
                    case DOUBLE: {
                        collection.add((Object)this.messageContext.in.readDouble());
                        continue block18;
                    }
                    case FLOAT: {
                        collection.add(Float.valueOf(this.messageContext.in.readFloat()));
                        continue block18;
                    }
                    case BOOL: {
                        collection.add((Object)this.messageContext.in.readBool());
                        continue block18;
                    }
                    case STRING: {
                        collection.add(this.messageContext.in.readString());
                        continue block18;
                    }
                    case BYTES: {
                        collection.add((Object)this.messageContext.in.readBytes().toByteArray());
                        continue block18;
                    }
                    case INT64: {
                        collection.add((Object)this.messageContext.in.readInt64());
                        continue block18;
                    }
                    case UINT64: {
                        collection.add((Object)this.messageContext.in.readUInt64());
                        continue block18;
                    }
                    case FIXED64: {
                        collection.add((Object)this.messageContext.in.readFixed64());
                        continue block18;
                    }
                    case SFIXED64: {
                        collection.add((Object)this.messageContext.in.readSFixed64());
                        continue block18;
                    }
                    case SINT64: {
                        collection.add((Object)this.messageContext.in.readSInt64());
                        continue block18;
                    }
                    case INT32: {
                        collection.add((Object)this.messageContext.in.readInt32());
                        continue block18;
                    }
                    case FIXED32: {
                        collection.add((Object)this.messageContext.in.readFixed32());
                        continue block18;
                    }
                    case UINT32: {
                        collection.add((Object)this.messageContext.in.readUInt32());
                        continue block18;
                    }
                    case SFIXED32: {
                        collection.add((Object)this.messageContext.in.readSFixed32());
                        continue block18;
                    }
                    case SINT32: {
                        collection.add((Object)this.messageContext.in.readSInt32());
                        continue block18;
                    }
                }
                throw new IllegalStateException("Unexpected field type : " + fd.getType());
            }
            this.messageContext.unknownFieldSet.mergeFieldFrom(tag, this.messageContext.in);
        }
    }

    @Override
    public <A> A[] readArray(String fieldName, Class<? extends A> clazz) throws IOException {
        List list = this.readCollection(fieldName, new ArrayList(), clazz);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    private void checkRepeatedField(Descriptors.FieldDescriptor fd) {
        if (!fd.isRepeated()) {
            throw new IllegalArgumentException("This field is not repeated and cannot be read with one of the methods intended for collections or arrays: " + fd.getName());
        }
        if (!this.messageContext.getSeenFields().add(fd.getNumber())) {
            throw new IllegalArgumentException("Cannot read a field twice : " + fd.getName());
        }
    }

    private void checkNonRepeatedField(Descriptors.FieldDescriptor fd) {
        if (fd.isRepeated()) {
            throw new IllegalArgumentException("A repeated field should be read with one of the methods intended for collections or arrays: " + fd.getName());
        }
        if (!this.messageContext.getSeenFields().add(fd.getNumber())) {
            throw new IllegalArgumentException("Cannot read a field twice : " + fd.getName());
        }
    }
}

