/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.ajp;

import io.undertow.client.ClientRequest;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.ajp.AjpClientExchange;
import io.undertow.conduits.ConduitListener;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.FixedLengthUnderflowException;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

final class AjpClientRequestConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final int MAX_DATA_SIZE = 8186;
    private static final Map<HttpString, Integer> HEADER_MAP;
    private static final Map<HttpString, Integer> HTTP_METHODS;
    private final Pool<ByteBuffer> pool;
    private Pooled<ByteBuffer> currentDataBuffer;
    private ByteBuffer headerDataBuffer;
    private final AjpClientExchange exchange;
    private final ConduitListener<? super AjpClientRequestConduit> finishListener;
    private final boolean hasContent;
    private long state;
    private long totalRemaining;
    private int requestedChunkSize = -1;
    private static final long STATE_MASK;
    private static final long FLAG_START = Long.MIN_VALUE;
    private static final long FLAG_SHUTDOWN = 0x4000000000000000L;
    private static final long FLAG_DELEGATE_SHUTDOWN = 0x2000000000000000L;
    private static final long FLAG_WRITES_RESUMED = 0x1000000000000000L;
    private static final long FLAG_FINAL_CHUNK_GENERATED = 0x800000000000000L;

    AjpClientRequestConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, AjpClientExchange exchange, ConduitListener<? super AjpClientRequestConduit> finishListener, long size) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
        this.finishListener = finishListener;
        this.hasContent = size != 0L;
        this.totalRemaining = size;
        this.state = Long.MIN_VALUE;
        if (this.hasContent) {
            this.requestedChunkSize = size > 0L ? 8186 : 0;
        }
    }

    private void putInt(ByteBuffer buf, int value) {
        buf.put((byte)(value >> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
    }

    private void putString(ByteBuffer buf, String value) {
        int length = value.length();
        this.putInt(buf, length);
        for (int i = 0; i < length; ++i) {
            buf.put((byte)value.charAt(i));
        }
        buf.put((byte)0);
    }

    void setBodyChunkRequested(int requestedSize) {
        this.requestedChunkSize = requestedSize;
        if (Bits.anyAreSet((long)this.state, (long)0x1000000000000000L)) {
            ((StreamSinkConduit)this.next).resumeWrites();
        }
    }

    private boolean processWrite() throws IOException {
        if (Bits.anyAreSet((long)this.state, (long)0x2000000000000000L)) {
            return true;
        }
        if (Bits.anyAreSet((long)this.state, (long)Long.MIN_VALUE)) {
            String storedMethod;
            String secret;
            Integer sslKeySize;
            byte[] sslSession;
            String sslCypher;
            String sslCert;
            String route;
            String authType;
            String remoteUser;
            String queryString;
            String path;
            this.state &= Long.MAX_VALUE;
            ClientRequest request = this.exchange.getRequest();
            int qsIndex = this.exchange.getRequest().getPath().indexOf(63);
            if (qsIndex == -1) {
                path = this.exchange.getRequest().getPath();
                queryString = null;
            } else {
                path = this.exchange.getRequest().getPath().substring(0, qsIndex);
                queryString = this.exchange.getRequest().getPath().substring(qsIndex + 1);
            }
            this.currentDataBuffer = this.pool.allocate();
            ByteBuffer buffer = (ByteBuffer)this.currentDataBuffer.getResource();
            buffer.put((byte)18);
            buffer.put((byte)52);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)2);
            Integer methodNp = HTTP_METHODS.get(request.getMethod());
            if (methodNp == null) {
                throw UndertowClientMessages.MESSAGES.unknownMethod(request.getMethod());
            }
            buffer.put((byte)methodNp.intValue());
            this.putString(buffer, this.exchange.getRequest().getProtocol().toString());
            this.putString(buffer, path);
            this.putString(buffer, this.notNull(request.getAttachment(ProxiedRequestAttachments.REMOTE_ADDRESS)));
            this.putString(buffer, this.notNull(request.getAttachment(ProxiedRequestAttachments.REMOTE_HOST)));
            this.putString(buffer, this.notNull(request.getAttachment(ProxiedRequestAttachments.SERVER_NAME)));
            this.putInt(buffer, this.notNull(request.getAttachment(ProxiedRequestAttachments.SERVER_PORT)));
            buffer.put((byte)(this.notNull(request.getAttachment(ProxiedRequestAttachments.IS_SSL)) ? 1 : 0));
            int headers = 0;
            HeaderMap responseHeaders = request.getRequestHeaders();
            for (HttpString name : responseHeaders.getHeaderNames()) {
                headers += responseHeaders.get(name).size();
            }
            this.putInt(buffer, headers);
            for (HttpString header : responseHeaders.getHeaderNames()) {
                for (String headerValue : responseHeaders.get(header)) {
                    Integer headerCode = HEADER_MAP.get(header);
                    if (headerCode != null) {
                        this.putInt(buffer, headerCode);
                    } else {
                        this.putString(buffer, header.toString());
                    }
                    this.putString(buffer, headerValue);
                }
            }
            if (queryString != null) {
                buffer.put((byte)5);
                this.putString(buffer, queryString);
            }
            if ((remoteUser = request.getAttachment(ProxiedRequestAttachments.REMOTE_USER)) != null) {
                buffer.put((byte)3);
                this.putString(buffer, remoteUser);
            }
            if ((authType = request.getAttachment(ProxiedRequestAttachments.AUTH_TYPE)) != null) {
                buffer.put((byte)4);
                this.putString(buffer, authType);
            }
            if ((route = request.getAttachment(ProxiedRequestAttachments.ROUTE)) != null) {
                buffer.put((byte)6);
                this.putString(buffer, route);
            }
            if ((sslCert = request.getAttachment(ProxiedRequestAttachments.SSL_CERT)) != null) {
                buffer.put((byte)7);
                this.putString(buffer, sslCert);
            }
            if ((sslCypher = request.getAttachment(ProxiedRequestAttachments.SSL_CYPHER)) != null) {
                buffer.put((byte)8);
                this.putString(buffer, sslCypher);
            }
            if ((sslSession = request.getAttachment(ProxiedRequestAttachments.SSL_SESSION_ID)) != null) {
                buffer.put((byte)9);
                this.putString(buffer, FlexBase64.encodeString(sslSession, false));
            }
            if ((sslKeySize = request.getAttachment(ProxiedRequestAttachments.SSL_KEY_SIZE)) != null) {
                buffer.put((byte)11);
                this.putString(buffer, sslKeySize.toString());
            }
            if ((secret = request.getAttachment(ProxiedRequestAttachments.SECRET)) != null) {
                buffer.put((byte)12);
                this.putString(buffer, secret);
            }
            if ((storedMethod = request.getAttachment(ProxiedRequestAttachments.STORED_METHOD)) != null) {
                buffer.put((byte)13);
                this.putString(buffer, storedMethod);
            }
            buffer.put((byte)-1);
            int dataLength = buffer.position() - 4;
            buffer.put(2, (byte)(dataLength >> 8 & 0xFF));
            buffer.put(3, (byte)(dataLength & 0xFF));
            buffer.flip();
            if (!this.hasContent) {
                this.state |= 0x4000000000000000L;
            }
        }
        return this.currentDataBuffer == null || this.writeCurrentBuffer();
    }

    private boolean handleFinalChunk() throws IOException {
        if (!this.hasContent) {
            return true;
        }
        if (Bits.anyAreSet((long)this.state, (long)0x4000000000000000L) && !Bits.anyAreSet((long)this.state, (long)0x800000000000000L)) {
            this.state |= 0x800000000000000L;
            if (this.totalRemaining < 0L) {
                ByteBuffer buffer;
                byte[] header = new byte[]{18, 52, 0, 2, 0, 0};
                this.headerDataBuffer = buffer = ByteBuffer.wrap(header);
            }
        }
        if (this.headerDataBuffer != null) {
            ByteBuffer buffer = this.headerDataBuffer;
            do {
                int r;
                if ((r = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                return false;
            } while (buffer.hasRemaining());
            this.headerDataBuffer = null;
            return true;
        }
        return true;
    }

    private boolean notNull(Boolean attachment) {
        return attachment == null ? false : attachment;
    }

    private int notNull(Integer attachment) {
        return attachment == null ? 0 : attachment;
    }

    private String notNull(String attachment) {
        return attachment == null ? "" : attachment;
    }

    private boolean writeCurrentBuffer() throws IOException {
        ByteBuffer buffer = (ByteBuffer)this.currentDataBuffer.getResource();
        do {
            int r;
            if ((r = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
            return false;
        } while (buffer.hasRemaining());
        this.currentDataBuffer.free();
        this.currentDataBuffer = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (!this.processWrite()) {
            return 0;
        }
        if (src.remaining() == 0) {
            return 0;
        }
        long remaining = this.state & STATE_MASK;
        if (remaining == 0L && this.requestedChunkSize <= 0) {
            ((StreamSinkConduit)this.next).suspendWrites();
            return 0;
        }
        if (remaining == 0L) {
            this.headerDataBuffer = this.createHeader(src);
            this.requestedChunkSize = 0;
            remaining = this.state & STATE_MASK;
        }
        int limit = src.limit();
        if ((long)src.remaining() > remaining) {
            src.limit((int)((long)src.position() + remaining));
        }
        try {
            ByteBuffer[] bufs;
            int headerLength = 0;
            if ((long)src.remaining() == remaining) {
                if (this.headerDataBuffer == null) {
                    bufs = new ByteBuffer[]{src};
                } else {
                    bufs = new ByteBuffer[]{this.headerDataBuffer, src};
                    headerLength = this.headerDataBuffer.remaining();
                }
            } else if (this.headerDataBuffer == null) {
                bufs = new ByteBuffer[]{src};
            } else {
                bufs = new ByteBuffer[]{this.headerDataBuffer, src};
                headerLength = this.headerDataBuffer.remaining();
            }
            int r = (int)((StreamSinkConduit)this.next).write(bufs, 0, bufs.length);
            r -= headerLength;
            if (!this.headerDataBuffer.hasRemaining()) {
                this.headerDataBuffer = null;
            }
            if (r > 0) {
                if ((remaining -= (long)r) < 0L) {
                    remaining = 0L;
                    --r;
                }
                if (this.totalRemaining > 0L) {
                    this.totalRemaining -= (long)r;
                }
                int n = r;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            src.limit(limit);
            this.state = this.state & (STATE_MASK ^ 0xFFFFFFFFFFFFFFFFL) | remaining;
        }
    }

    private ByteBuffer createHeader(ByteBuffer src) {
        int remaining = src.remaining();
        remaining = Math.min(remaining, 8186);
        remaining = Math.min(remaining, this.requestedChunkSize);
        int bodySize = remaining + 3;
        byte[] header = new byte[]{18, 52, (byte)(bodySize >> 8 & 0xFF), (byte)(bodySize & 0xFF), (byte)(remaining >> 8 & 0xFF), (byte)(remaining & 0xFF)};
        this.state = this.state & (STATE_MASK ^ 0xFFFFFFFFFFFFFFFFL) | (long)remaining;
        return ByteBuffer.wrap(header);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            while (srcs[i].hasRemaining()) {
                int written = this.write(srcs[i]);
                if (written <= 0 && total == 0L) {
                    return written;
                }
                if (written <= 0) {
                    return total;
                }
                total += (long)written;
            }
        }
        return total;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public boolean flush() throws IOException {
        if (!this.processWrite()) {
            return false;
        }
        if (Bits.allAreClear((long)this.state, (long)0x4000000000000000L)) {
            return ((StreamSinkConduit)this.next).flush();
        }
        if (!this.handleFinalChunk()) {
            return false;
        }
        long state = this.state;
        if (Bits.allAreSet((long)state, (long)0x4000000000000000L) && Bits.allAreClear((long)state, (long)0x2000000000000000L)) {
            if (this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
            this.state |= 0x2000000000000000L;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    public void suspendWrites() {
        this.state &= 0xEFFFFFFFFFFFFFFFL;
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    public void resumeWrites() {
        this.state |= 0x1000000000000000L;
        long remaining = this.state & STATE_MASK;
        if (remaining != 0L || this.requestedChunkSize != 0) {
            ((StreamSinkConduit)this.next).resumeWrites();
        }
    }

    public boolean isWriteResumed() {
        return Bits.anyAreSet((long)this.state, (long)0x1000000000000000L);
    }

    public void wakeupWrites() {
        this.state |= 0x1000000000000000L;
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    public void terminateWrites() throws IOException {
        long remaining = this.state & STATE_MASK;
        if (remaining != 0L) {
            try {
                throw UndertowClientMessages.MESSAGES.dataStillRemainingInChunk(remaining);
            }
            catch (Throwable throwable) {
                ((StreamSinkConduit)this.next).truncateWrites();
                throw throwable;
            }
        }
        if (this.totalRemaining > 0L) {
            try {
                throw new FixedLengthUnderflowException(this.totalRemaining + " bytes remaining");
            }
            catch (Throwable throwable) {
                ((StreamSinkConduit)this.next).truncateWrites();
                throw throwable;
            }
        }
        long state = this.state;
        if (Bits.anyAreSet((long)state, (long)0x4000000000000000L)) {
            return;
        }
        this.state |= 0x4000000000000000L;
    }

    public void awaitWritable() throws IOException {
        throw new IllegalStateException();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        throw new IllegalStateException();
    }

    static {
        STATE_MASK = Bits.longBitMask((int)0, (int)58);
        HashMap<HttpString, Integer> headers = new HashMap<HttpString, Integer>();
        headers.put(Headers.ACCEPT, 40961);
        headers.put(Headers.ACCEPT_CHARSET, 40962);
        headers.put(Headers.ACCEPT_ENCODING, 40963);
        headers.put(Headers.ACCEPT_LANGUAGE, 40964);
        headers.put(Headers.AUTHORIZATION, 40965);
        headers.put(Headers.CONNECTION, 40966);
        headers.put(Headers.CONTENT_TYPE, 40967);
        headers.put(Headers.CONTENT_LENGTH, 40968);
        headers.put(Headers.COOKIE, 40969);
        headers.put(Headers.COOKIE2, 40970);
        headers.put(Headers.HOST, 40971);
        headers.put(Headers.PRAGMA, 40972);
        headers.put(Headers.REFERER, 40973);
        headers.put(Headers.USER_AGENT, 40974);
        HEADER_MAP = Collections.unmodifiableMap(headers);
        HashMap<HttpString, Integer> methods = new HashMap<HttpString, Integer>();
        methods.put(Methods.OPTIONS, 1);
        methods.put(Methods.GET, 2);
        methods.put(Methods.HEAD, 3);
        methods.put(Methods.POST, 4);
        methods.put(Methods.PUT, 5);
        methods.put(Methods.DELETE, 6);
        methods.put(Methods.TRACE, 7);
        methods.put(Methods.PROPFIND, 8);
        methods.put(Methods.PROPPATCH, 9);
        methods.put(Methods.MKCOL, 10);
        methods.put(Methods.COPY, 11);
        methods.put(Methods.MOVE, 12);
        methods.put(Methods.LOCK, 13);
        methods.put(Methods.UNLOCK, 14);
        methods.put(Methods.ACL, 15);
        methods.put(Methods.REPORT, 16);
        methods.put(Methods.VERSION_CONTROL, 17);
        methods.put(Methods.CHECKIN, 18);
        methods.put(Methods.CHECKOUT, 19);
        methods.put(Methods.UNCHECKOUT, 20);
        methods.put(Methods.SEARCH, 21);
        methods.put(Methods.MKWORKSPACE, 22);
        methods.put(Methods.UPDATE, 23);
        methods.put(Methods.LABEL, 24);
        methods.put(Methods.MERGE, 25);
        methods.put(Methods.BASELINE_CONTROL, 26);
        methods.put(Methods.MKACTIVITY, 27);
        HTTP_METHODS = Collections.unmodifiableMap(methods);
    }
}

