/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.EventInvoker;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterService;

public class Host
implements Service<Host> {
    private final PathHandler pathHandler = new PathHandler();
    private volatile HttpHandler rootHandler = this.pathHandler;
    private final Set<String> allAliases;
    private final String name;
    private final String defaultWebModule;
    private final InjectedValue<Server> server = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final InjectedValue<AccessLogService> accessLogService = new InjectedValue();
    private final List<InjectedValue<FilterService>> injectedFilters = new CopyOnWriteArrayList<InjectedValue<FilterService>>();
    private final Set<Deployment> deployments = new CopyOnWriteArraySet<Deployment>();

    protected Host(String name, List<String> aliases, String defaultWebModule) {
        this.name = name;
        this.defaultWebModule = defaultWebModule;
        HashSet<String> hosts = new HashSet<String>(aliases.size() + 1);
        hosts.add(name);
        hosts.addAll(aliases);
        this.allAliases = Collections.unmodifiableSet(hosts);
    }

    private String getDeployedContextPath(DeploymentInfo deploymentInfo) {
        return "".equals(deploymentInfo.getContextPath()) ? "/" : deploymentInfo.getContextPath();
    }

    public void start(StartContext context) throws StartException {
        this.rootHandler = this.configureRootHandler();
        ((Server)this.server.getValue()).registerHost(this);
        UndertowLogger.ROOT_LOGGER.hostStarting(this.name);
    }

    private HttpHandler configureRootHandler() {
        AccessLogService logService = (AccessLogService)this.accessLogService.getOptionalValue();
        if (logService != null) {
            this.rootHandler = logService.configureAccessLogHandler((HttpHandler)this.pathHandler);
        }
        ArrayList<Object> filters = new ArrayList<Object>(this.injectedFilters.size());
        for (InjectedValue<FilterService> injectedFilter : this.injectedFilters) {
            filters.add(injectedFilter.getValue());
        }
        Collections.reverse(filters);
        HttpHandler handler = this.rootHandler;
        for (FilterService filterService : filters) {
            handler = filterService.createHttpHandler(handler);
        }
        return handler;
    }

    public void stop(StopContext context) {
        ((Server)this.server.getValue()).unregisterHost(this);
        this.pathHandler.clearPaths();
        UndertowLogger.ROOT_LOGGER.hostStopping(this.name);
    }

    public Host getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<Server> getServerInjection() {
        return this.server;
    }

    protected InjectedValue<AccessLogService> getAccessLogService() {
        return this.accessLogService;
    }

    public Server getServer() {
        return (Server)this.server.getValue();
    }

    protected InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    public String getName() {
        return this.name;
    }

    protected HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public String getDefaultWebModule() {
        return this.defaultWebModule;
    }

    public void registerDeployment(final Deployment deployment, HttpHandler handler) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        this.registerHandler(path, handler);
        this.deployments.add(deployment);
        UndertowLogger.ROOT_LOGGER.registerWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onDeploymentStart(deployment, Host.this);
            }
        });
    }

    public void unregisterDeployment(final Deployment deployment) {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String path = this.getDeployedContextPath(deploymentInfo);
        this.unregisterHandler(path);
        this.deployments.remove(deployment);
        UndertowLogger.ROOT_LOGGER.unregisterWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(new EventInvoker(){

            @Override
            public void invoke(UndertowEventListener listener) {
                listener.onDeploymentStop(deployment, Host.this);
            }
        });
    }

    public void registerHandler(String path, HttpHandler handler) {
        this.pathHandler.addPath(path, handler);
    }

    public void unregisterHandler(String path) {
        this.pathHandler.removePath(path);
    }

    public Set<Deployment> getDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }

    public List<InjectedValue<FilterService>> getInjectedFilters() {
        return this.injectedFilters;
    }
}

