/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.servlet.ServletRequest;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.auth.callback.JASPICallbackHandler;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.extension.undertow.security.jaspi.SecurityActions;

public class JASPIAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String JASPI_HTTP_SERVLET_LAYER = "HttpServlet";
    private static final String MECHANISM_NAME = "JASPI";
    public static final AttachmentKey<HttpServerExchange> HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY = AttachmentKey.create(HttpServerExchange.class);
    public static final AttachmentKey<SecurityContext> SECURITY_CONTEXT_ATTACHMENT_KEY = AttachmentKey.create(SecurityContext.class);
    private final String securityDomain;

    public JASPIAuthenticationMechanism(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        JASPIServerAuthenticationManager sam = this.createJASPIAuthenticationManager();
        GenericMessageInfo messageInfo = this.createMessageInfo(exchange, securityContext);
        String applicationIdentifier = this.buildApplicationIdentifier(requestContext);
        JASPICallbackHandler cbh = new JASPICallbackHandler();
        UndertowLogger.ROOT_LOGGER.debugf("validateRequest for layer [%s] and applicationContextIdentifier [%s]", JASPI_HTTP_SERVLET_LAYER, applicationIdentifier);
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        Account account = null;
        boolean isValid = sam.isValid((MessageInfo)messageInfo, new Subject(), JASPI_HTTP_SERVLET_LAYER, applicationIdentifier, (CallbackHandler)cbh);
        if (isValid) {
            org.jboss.security.SecurityContext jbossSct = SecurityActions.getSecurityContext();
            account = this.createAccount(jbossSct);
        }
        if (isValid && account != null) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            securityContext.authenticationComplete(account, MECHANISM_NAME, false);
        } else if (isValid && account == null && !this.isMandatory(requestContext).booleanValue()) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        } else {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            securityContext.authenticationFailed("JASPI authentication failed.", MECHANISM_NAME);
        }
        this.secureResponse(exchange, securityContext, sam, messageInfo, cbh);
        return outcome;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true);
    }

    private boolean isSecureResponse(ServletRequestContext attachment, SecurityContext securityContext) {
        return !this.wasAuthExceptionThrown();
    }

    private boolean wasAuthExceptionThrown() {
        return SecurityContextAssociation.getSecurityContext().getData().get(AuthException.class.getName()) != null;
    }

    private JASPIServerAuthenticationManager createJASPIAuthenticationManager() {
        return new JASPIServerAuthenticationManager(this.securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    private String buildApplicationIdentifier(ServletRequestContext attachment) {
        ServletRequest servletRequest = attachment.getServletRequest();
        return servletRequest.getLocalName() + " " + servletRequest.getServletContext().getContextPath();
    }

    private GenericMessageInfo createMessageInfo(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)servletRequestContext.getServletRequest());
        messageInfo.setResponseMessage((Object)servletRequestContext.getServletResponse());
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", this.isMandatory(servletRequestContext).toString());
        messageInfo.getMap().put(SECURITY_CONTEXT_ATTACHMENT_KEY, securityContext);
        messageInfo.getMap().put(HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY, exchange);
        return messageInfo;
    }

    private Account createAccount(org.jboss.security.SecurityContext jbossSct) {
        if (jbossSct == null) {
            throw UndertowMessages.MESSAGES.nullParamter("org.jboss.security.SecurityContext");
        }
        Principal userPrincipal = jbossSct.getUtil().getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        HashSet<String> stringRoles = new HashSet<String>();
        RoleGroup roleGroup = jbossSct.getUtil().getRoles();
        if (roleGroup != null) {
            for (Role role : roleGroup.getRoles()) {
                stringRoles.add(role.getRoleName());
            }
        }
        Object credential = jbossSct.getUtil().getCredential();
        return new AccountImpl(userPrincipal, stringRoles, credential);
    }

    private void secureResponse(HttpServerExchange exchange, final SecurityContext securityContext, final JASPIServerAuthenticationManager sam, final GenericMessageInfo messageInfo, final JASPICallbackHandler cbh) {
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                String applicationIdentifier = JASPIAuthenticationMechanism.this.buildApplicationIdentifier(requestContext);
                if (JASPIAuthenticationMechanism.this.isSecureResponse(requestContext, securityContext)) {
                    UndertowLogger.ROOT_LOGGER.debugf("secureResponse for layer [%s] and applicationContextIdentifier [%s].", JASPIAuthenticationMechanism.JASPI_HTTP_SERVLET_LAYER, applicationIdentifier);
                    sam.secureResponse((MessageInfo)messageInfo, new Subject(), JASPIAuthenticationMechanism.JASPI_HTTP_SERVLET_LAYER, applicationIdentifier, (CallbackHandler)cbh);
                }
                nextListener.proceed();
            }
        });
    }

    private Boolean isMandatory(ServletRequestContext attachment) {
        return attachment.getCurrentServlet() != null && attachment.getCurrentServlet().getManagedServlet() != null && attachment.getCurrentServlet().getManagedServlet().getServletInfo() != null && attachment.getCurrentServlet().getManagedServlet().getServletInfo().getServletSecurityInfo() != null && attachment.getCurrentServlet().getManagedServlet().getServletInfo().getServletSecurityInfo().getRolesAllowed() != null && !attachment.getCurrentServlet().getManagedServlet().getServletInfo().getServletSecurityInfo().getRolesAllowed().isEmpty();
    }
}

