/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.ThreadLocalSSLSocketFactory;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LdapConnectionManagerService
implements Service<LdapConnectionManagerService>,
ConnectionManager {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private final InjectedValue<SSLIdentity> sslIdentity = new InjectedValue();
    private volatile Config configuration;
    private volatile Hashtable<String, String> properties = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config setConfiguration(String initialContextFactory, String url, String searchDn, String searchCredential) {
        Config configuration = new Config();
        configuration.initialContextFactory = initialContextFactory;
        configuration.url = url;
        configuration.searchDn = searchDn;
        configuration.searchCredential = searchCredential;
        try {
            Config config = this.configuration;
            return config;
        }
        finally {
            this.configuration = configuration;
        }
    }

    void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    public synchronized void start(StartContext context) throws StartException {
    }

    public synchronized void stop(StopContext context) {
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<SSLIdentity> getSSLIdentityInjector() {
        return this.sslIdentity;
    }

    synchronized void setProperty(String name, String value) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.put(name, value);
        this.properties = properties;
    }

    synchronized void removeProperty(String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.remove(name);
        this.properties = properties;
    }

    void setPropertyImmediate(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getConnection() throws Exception {
        return this.getConnection(this.getFullProperties(this.configuration), this.getSSLContext(false));
    }

    @Override
    public Object getConnection(String principal, String credential) throws Exception {
        Hashtable<String, String> connectionProperties = this.getConnectionOnlyProperties(this.configuration);
        connectionProperties.put("java.naming.security.principal", principal);
        connectionProperties.put("java.naming.security.credentials", credential);
        return this.getConnection(connectionProperties, this.getSSLContext(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConnection(Hashtable<String, String> properties, SSLContext sslContext) throws Exception {
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.setSSLSocketFactory(sslContext.getSocketFactory());
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(ThreadLocalSSLSocketFactory.class);
                properties.put("java.naming.ldap.factory.socket", ThreadLocalSSLSocketFactory.class.getName());
            }
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                Hashtable<String, String> logProperties;
                if (properties.containsKey("java.naming.security.credentials")) {
                    logProperties = new Hashtable<String, String>(properties);
                    logProperties.put("java.naming.security.credentials", "***");
                } else {
                    logProperties = properties;
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("Connecting to LDAP with properties (%s)", logProperties.toString());
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.removeSSLSocketFactory();
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
        }
    }

    private SSLContext getSSLContext(boolean trustOnly) {
        SSLIdentity sslIdentityValue = (SSLIdentity)this.sslIdentity.getOptionalValue();
        if (sslIdentityValue != null) {
            return trustOnly ? sslIdentityValue.getTrustOnlyContext() : sslIdentityValue.getFullContext();
        }
        return null;
    }

    private Hashtable<String, String> getConnectionOnlyProperties(Config configuration) {
        Hashtable<String, String> result = new Hashtable<String, String>(this.properties);
        result.put("java.naming.factory.initial", configuration.initialContextFactory);
        result.put("java.naming.provider.url", configuration.url);
        return result;
    }

    private Hashtable<String, String> getFullProperties(Config configuration) {
        Hashtable<String, String> result = this.getConnectionOnlyProperties(configuration);
        if (configuration.searchDn != null) {
            result.put("java.naming.security.principal", configuration.searchDn);
        }
        if (configuration.searchCredential != null) {
            result.put("java.naming.security.credentials", configuration.searchCredential);
        }
        return result;
    }

    static class Config {
        private String initialContextFactory;
        private String url;
        private String searchDn;
        private String searchCredential;

        Config() {
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String connectionName) {
            return BASE_SERVICE_NAME.append(new String[]{connectionName});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<ConnectionManager> injector, String connectionName, boolean optional) {
            ServiceBuilder.DependencyType type = optional ? ServiceBuilder.DependencyType.OPTIONAL : ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(connectionName), ConnectionManager.class, injector);
            return sb;
        }
    }
}

