/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.naming.Context;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.embedded.EmbeddedMessages;
import org.jboss.as.embedded.StandaloneServer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

final class StandaloneServerIndirection
implements StandaloneServer {
    private final Object standaloneServer;
    private final Method methodStart;
    private final Method methodStop;
    private final Method methodGetContext;
    private final Method methodGetService;
    private final Method methodGetModelControllerClient;
    private final Method methodDeploy;
    private final Method methodUndeploy;

    StandaloneServerIndirection(Class<?> standaloneServerClass, Object standaloneServerImpl) {
        this.standaloneServer = standaloneServerImpl;
        try {
            this.methodStart = standaloneServerClass.getMethod("start", new Class[0]);
            this.methodStop = standaloneServerClass.getMethod("stop", new Class[0]);
            this.methodGetContext = standaloneServerClass.getMethod("getContext", new Class[0]);
            this.methodGetService = standaloneServerClass.getMethod("getService", ServiceName.class);
            this.methodGetModelControllerClient = standaloneServerClass.getMethod("getModelControllerClient", new Class[0]);
            this.methodDeploy = standaloneServerClass.getMethod("deploy", File.class);
            this.methodUndeploy = standaloneServerClass.getMethod("undeploy", File.class);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedMessages.MESSAGES.cannotGetReflectiveMethod(nsme, nsme.getMessage(), standaloneServerClass.getName());
        }
    }

    @Override
    public void start() {
        this.invokeOnServer(this.methodStart, new Object[0]);
    }

    @Override
    public void stop() {
        this.invokeOnServer(this.methodStop, new Object[0]);
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return (ServiceController)this.invokeOnServer(this.methodGetService, serviceName);
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return (ModelControllerClient)this.invokeOnServer(this.methodGetModelControllerClient, new Object[0]);
    }

    @Override
    public void deploy(File file) {
        this.invokeOnServer(this.methodDeploy, file);
    }

    @Override
    public void undeploy(File file) throws ExecutionException, InterruptedException {
        this.invokeOnServer(this.methodUndeploy, file);
    }

    @Override
    public Context getContext() {
        return (Context)this.invokeOnServer(this.methodGetContext, new Object[0]);
    }

    private Object invokeOnServer(Method method, Object ... args) {
        try {
            return method.invoke(this.standaloneServer, args);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)ex).getCause();
            }
            throw EmbeddedMessages.MESSAGES.cannotInvokeStandaloneServer(cause, method.getName());
        }
    }
}

