/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.EventLoop;
import java.io.IOException;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.netty.transport.AbstractXnioServerSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;

public final class XnioServerSocketChannel
extends AbstractXnioServerSocketChannel {
    private final OptionMap.Builder options = OptionMap.builder();
    private volatile AcceptingChannel channel;
    private volatile EventLoop eventLoop;

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof XnioEventLoop;
    }

    public EventLoop eventLoop() {
        if (this.eventLoop == null) {
            return super.eventLoop();
        }
        return this.eventLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind(SocketAddress localAddress) throws Exception {
        XnioWorker worker = ((XnioEventLoop)this.eventLoop()).ioThread().getWorker();
        XnioServerSocketChannel xnioServerSocketChannel = this;
        synchronized (xnioServerSocketChannel) {
            OptionMap map = this.options.set(Options.WORKER_IO_THREADS, worker.getIoThreadCount()).getMap();
            XnioEventLoop eventLoop = (XnioEventLoop)this.eventLoop();
            this.channel = eventLoop.ioThread().getWorker().createStreamConnectionServer(localAddress, (ChannelListener)new AbstractXnioServerSocketChannel.AcceptListener(), map);
            this.eventLoop = new XnioEventLoop(eventLoop.parent(), this.channel.getIoThread());
        }
        this.channel.resumeAccepts();
    }

    @Override
    protected <T> T getOption0(Option<T> option) throws IOException {
        if (this.channel != null) {
            return (T)this.channel.getOption(option);
        }
        return (T)this.options.getMap().get(option);
    }

    @Override
    protected synchronized <T> void setOption0(Option<T> option, T value) throws IOException {
        if (this.channel != null) {
            this.channel.setOption(option, value);
        } else {
            this.options.set(option, value);
        }
    }

    @Override
    protected AcceptingChannel xnioChannel() {
        return this.channel;
    }
}

