/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.servlet.http.HttpSession;
import org.xnio.Pooled;

public class SavedRequest {
    private static final String SESSION_KEY = SavedRequest.class.getName();
    private final ByteBuffer data;
    private final HttpString method;
    private final String requestUri;

    public SavedRequest(ByteBuffer data, HttpString method, String requestUri) {
        this.data = data;
        this.method = method;
        this.requestUri = requestUri;
    }

    public static void trySaveRequest(HttpServerExchange exchange) {
        int maxSize = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERED_REQUEST_SIZE, 16384);
        if (maxSize > 0 && !exchange.isRequestComplete()) {
            long requestContentLength = exchange.getRequestContentLength();
            if (requestContentLength > (long)maxSize) {
                UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                return;
            }
            byte[] buffer = new byte[maxSize];
            int read = 0;
            int res = 0;
            InputStream in = exchange.getInputStream();
            try {
                while ((res = in.read(buffer)) > 0) {
                    if ((read += res) != maxSize) continue;
                    UndertowLogger.REQUEST_LOGGER.debugf("Request to %s was to large to save", (Object)exchange.getRequestURI());
                    return;
                }
                ByteBuffer data = ByteBuffer.wrap(buffer, 0, read);
                SavedRequest request = new SavedRequest(data, exchange.getRequestMethod(), exchange.getRequestURI());
                ServletRequestContext sc = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                HttpSessionImpl session = sc.getCurrentServetContext().getSession(exchange, true);
                session.setAttribute(SESSION_KEY, request);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            }
        }
    }

    public static void tryRestoreRequest(HttpServerExchange exchange, HttpSession session) {
        SavedRequest request = (SavedRequest)session.getAttribute(SESSION_KEY);
        if (request != null && request.requestUri.equals(exchange.getRequestURI())) {
            UndertowLogger.REQUEST_LOGGER.debugf("restoring request body for request to %s", (Object)request.requestUri);
            exchange.setRequestMethod(request.method);
            Connectors.ungetRequestBytes((HttpServerExchange)exchange, (Pooled[])new Pooled[]{new ImmediatePooled((Object)request.data)});
            session.removeAttribute(SESSION_KEY);
        }
    }
}

