/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.HandlerOperations;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperationTransformer;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.LoggingResourceTransformer;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.Transformers1_1_0;
import org.jboss.as.logging.logmanager.PropertySorter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

abstract class AbstractHandlerDefinition
extends TransformerResourceDefinition {
    public static final String UPDATE_OPERATION_NAME = "update-properties";
    public static final String CHANGE_LEVEL_OPERATION_NAME = "change-log-level";
    public static final PropertyAttributeDefinition FORMATTER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("formatter", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"named-formatter"})).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                writer.writeStartElement(PatternFormatterResourceDefinition.PATTERN_FORMATTER.getXmlName());
                String pattern = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(PatternFormatterResourceDefinition.PATTERN.getXmlName(), pattern);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).setDefaultValue(new ModelNode("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%E%n"))).build();
    public static final SimpleAttributeDefinition NAMED_FORMATTER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"named-formatter", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false).setAlternatives(new String[]{"formatter"}).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(FORMATTER.getXmlName());
                writer.writeStartElement(attribute.getXmlName());
                String content = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(CommonAttributes.NAME.getName(), content);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).build();
    static final AttributeDefinition[] DEFAULT_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.LEVEL, CommonAttributes.ENABLED, CommonAttributes.ENCODING, FORMATTER, CommonAttributes.FILTER_SPEC};
    static final AttributeDefinition[] LEGACY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.FILTER};
    static final ResourceDescriptionResolver HANDLER_RESOLVER = LoggingExtension.getResourceDescriptionResolver(CommonAttributes.HANDLER.getName());
    static final SimpleOperationDefinition ENABLE_HANDLER = new SimpleOperationDefinitionBuilder("enable", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final SimpleOperationDefinition DISABLE_HANDLER = new SimpleOperationDefinitionBuilder("disable", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).build();
    static final SimpleOperationDefinition CHANGE_LEVEL = new SimpleOperationDefinitionBuilder("change-log-level", HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(new AttributeDefinition[]{CommonAttributes.LEVEL}).build();
    private final OperationStepHandler writeHandler;
    private final AttributeDefinition[] writableAttributes;
    private final AttributeDefinition[] readOnlyAttributes;
    private final PropertySorter propertySorter;

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes) {
        this(path, type, PropertySorter.NO_OP, attributes);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, PropertySorter propertySorter, AttributeDefinition[] attributes) {
        this(path, type, propertySorter, attributes, null, attributes, new ConfigurationProperty[0]);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
        this(path, type, PropertySorter.NO_OP, attributes, null, attributes, constructionProperties);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, AttributeDefinition[] addAttributes, AttributeDefinition[] readOnlyAttributes, AttributeDefinition[] writableAttributes, ConfigurationProperty<?> ... constructionProperties) {
        this(path, type, PropertySorter.NO_OP, addAttributes, readOnlyAttributes, writableAttributes, constructionProperties);
    }

    protected AbstractHandlerDefinition(PathElement path, Class<? extends Handler> type, PropertySorter propertySorter, AttributeDefinition[] addAttributes, AttributeDefinition[] readOnlyAttributes, AttributeDefinition[] writableAttributes, ConfigurationProperty<?> ... constructionProperties) {
        super(path, HANDLER_RESOLVER, new HandlerOperations.HandlerAddOperationStepHandler(propertySorter, type, addAttributes, constructionProperties), HandlerOperations.REMOVE_HANDLER);
        this.writableAttributes = writableAttributes;
        this.writeHandler = new HandlerOperations.LogHandlerWriteAttributeHandler(propertySorter, this.writableAttributes);
        this.readOnlyAttributes = readOnlyAttributes;
        this.propertySorter = propertySorter;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition def : this.writableAttributes) {
            if (def.getName().equals(CommonAttributes.FILTER.getName())) {
                resourceRegistration.registerReadWriteAttribute(def, (OperationStepHandler)LoggingOperations.ReadFilterOperationStepHandler.INSTANCE, this.writeHandler);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(def, null, this.writeHandler);
        }
        if (this.readOnlyAttributes != null) {
            for (AttributeDefinition def : this.readOnlyAttributes) {
                resourceRegistration.registerReadOnlyAttribute(def, null);
            }
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CommonAttributes.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler((OperationDefinition)ENABLE_HANDLER, (OperationStepHandler)HandlerOperations.ENABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)DISABLE_HANDLER, (OperationStepHandler)HandlerOperations.DISABLE_HANDLER);
        registration.registerOperationHandler((OperationDefinition)CHANGE_LEVEL, HandlerOperations.CHANGE_LEVEL);
        SimpleOperationDefinition updateProperties = new SimpleOperationDefinitionBuilder(UPDATE_OPERATION_NAME, HANDLER_RESOLVER).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0)).setParameters(this.writableAttributes).build();
        registration.registerOperationHandler((OperationDefinition)updateProperties, (OperationStepHandler)new HandlerOperations.HandlerUpdateOperationStepHandler(this.propertySorter, this.writableAttributes));
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder rootResourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        if (modelVersion.hasTransformers()) {
            PathElement pathElement = this.getPathElement();
            ResourceTransformationDescriptionBuilder resourceBuilder = rootResourceBuilder.addChildResource(pathElement);
            ResourceTransformationDescriptionBuilder loggingProfileResourceBuilder = null;
            switch (modelVersion) {
                case VERSION_1_1_0: {
                    ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)resourceBuilder.getAttributeBuilder().setDiscard(Transformers1_1_0.LEVEL_ALL_DISCARD_CHECKER, new AttributeDefinition[]{CommonAttributes.LEVEL})).setValueConverter(Transformers1_1_0.CONSOLE_COLOR_CONVERTER, new AttributeDefinition[]{FORMATTER})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{CommonAttributes.FILTER_SPEC})).setValueConverter(Transformers1_1_0.FILTER_SPEC_CONVERTER, new AttributeDefinition[]{CommonAttributes.FILTER_SPEC})).addRename((AttributeDefinition)CommonAttributes.FILTER_SPEC, CommonAttributes.FILTER.getName())).setDiscard(Transformers1_1_0.DISCARD_ENABLED, new AttributeDefinition[]{CommonAttributes.ENABLED})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CommonAttributes.ENABLED})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, DEFAULT_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, LEGACY_ATTRIBUTES)).end().addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)LoggingOperationTransformer.INSTANCE).inheritResourceAttributeDefinitions().end().setCustomResourceTransformer((ResourceTransformer)new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME}));
                }
                case VERSION_1_2_0: 
                case VERSION_1_3_0: {
                    ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)resourceBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).end();
                    if (loggingProfileBuilder == null) break;
                    loggingProfileResourceBuilder = loggingProfileBuilder.addChildResource(pathElement);
                    ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)loggingProfileResourceBuilder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{NAMED_FORMATTER})).end();
                }
            }
            this.registerResourceTransformers(modelVersion, resourceBuilder, loggingProfileResourceBuilder);
        }
    }

    protected abstract void registerResourceTransformers(KnownModelVersion var1, ResourceTransformationDescriptionBuilder var2, ResourceTransformationDescriptionBuilder var3);
}

