/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.HostRunningModeControl;
import org.jboss.as.host.controller.RestartMode;
import org.jboss.as.process.DefaultJvmUtils;
import org.jboss.as.version.ProductConfig;
import org.wildfly.security.manager.WildFlySecurityManager;

public class HostControllerEnvironment
extends ProcessEnvironment {
    public static final String HOME_DIR = "jboss.home.dir";
    @Deprecated
    public static final String MODULES_DIR = "jboss.modules.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_DATA_DIR = "jboss.domain.data.dir";
    public static final String DOMAIN_CONTENT_DIR = "jboss.domain.content.dir";
    @Deprecated
    public static final String DOMAIN_DEPLOYMENT_DIR = "jboss.domain.deployment.dir";
    public static final String DOMAIN_LOG_DIR = "jboss.domain.log.dir";
    public static final String DOMAIN_SERVERS_DIR = "jboss.domain.servers.dir";
    public static final String DOMAIN_TEMP_DIR = "jboss.domain.temp.dir";
    public static final String HOST_NAME = "jboss.host.name";
    public static final String QUALIFIED_HOST_NAME = "jboss.qualified.host.name";
    public static final String CONTROLLER_TEMP_DIR = "jboss.controller.temp.dir";
    public static final String JBOSS_BIND_ADDRESS = "jboss.bind.address";
    public static final String JBOSS_BIND_ADDRESS_PREFIX = "jboss.bind.address.";
    public static final String JBOSS_DEFAULT_MULTICAST_ADDRESS = "jboss.default.multicast.address";
    public static final String JBOSS_DOMAIN_MASTER_ADDRESS = "jboss.domain.master.address";
    public static final String JBOSS_DOMAIN_MASTER_PORT = "jboss.domain.master.port";
    public static final String JBOSS_DOMAIN_DEFAULT_CONFIG = "jboss.domain.default.config";
    public static final String JBOSS_HOST_DEFAULT_CONFIG = "jboss.host.default.config";
    private final Map<String, String> hostSystemProperties;
    private final InetAddress processControllerAddress;
    private final Integer processControllerPort;
    private final InetAddress hostControllerAddress;
    private final Integer hostControllerPort;
    private final File homeDir;
    private final File modulesDir;
    private final File domainBaseDir;
    private final File domainConfigurationDir;
    private final ConfigurationFile hostConfigurationFile;
    private final ConfigurationFile domainConfigurationFile;
    private final File domainContentDir;
    private final File domainDataDir;
    private final File domainLogDir;
    private final File domainServersDir;
    private final File domainTempDir;
    private final File defaultJVM;
    private final boolean isRestart;
    private final boolean backupDomainFiles;
    private final boolean useCachedDc;
    private final RunningMode initialRunningMode;
    private final ProductConfig productConfig;
    private final String qualifiedHostName;
    private final String hostName;
    private final String modulePath;
    private volatile String hostControllerName;
    private final HostRunningModeControl runningModeControl;

    public HostControllerEnvironment(Map<String, String> hostSystemProperties, boolean isRestart, String modulePath, InetAddress processControllerAddress, Integer processControllerPort, InetAddress hostControllerAddress, Integer hostControllerPort, String defaultJVM, String domainConfig, String initialDomainConfig, String hostConfig, String initialHostConfig, RunningMode initialRunningMode, boolean backupDomainFiles, boolean useCachedDc, ProductConfig productConfig) {
        File home;
        if (hostSystemProperties == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostSystemProperties");
        }
        this.hostSystemProperties = Collections.unmodifiableMap(hostSystemProperties);
        if (modulePath == null) {
            throw HostControllerMessages.MESSAGES.nullVar("modulePath");
        }
        if (processControllerAddress == null) {
            throw HostControllerMessages.MESSAGES.nullVar("processControllerAddress");
        }
        if (processControllerPort == null) {
            throw HostControllerMessages.MESSAGES.nullVar("processControllerPort");
        }
        if (hostControllerAddress == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostControllerAddress");
        }
        if (hostControllerPort == null) {
            throw HostControllerMessages.MESSAGES.nullVar("hostControllerPort");
        }
        this.processControllerPort = processControllerPort;
        this.processControllerAddress = processControllerAddress;
        this.hostControllerAddress = hostControllerAddress;
        this.hostControllerPort = hostControllerPort;
        this.isRestart = isRestart;
        this.modulePath = modulePath;
        this.initialRunningMode = initialRunningMode;
        this.runningModeControl = new HostRunningModeControl(initialRunningMode, RestartMode.SERVERS);
        String hostName = hostSystemProperties.get(HOST_NAME);
        String qualifiedHostName = hostSystemProperties.get(QUALIFIED_HOST_NAME);
        if (qualifiedHostName == null) {
            Map env = null;
            qualifiedHostName = hostName;
            if (qualifiedHostName == null) {
                env = WildFlySecurityManager.getSystemEnvironmentPrivileged();
                qualifiedHostName = (String)env.get("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = (String)env.get("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
        }
        this.qualifiedHostName = qualifiedHostName;
        this.hostControllerName = qualifiedHostName;
        if (hostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
        }
        this.hostName = hostName;
        this.homeDir = home = this.getFileFromProperty(HOME_DIR);
        if (this.homeDir == null) {
            throw HostControllerMessages.MESSAGES.missingHomeDirConfiguration(HOME_DIR);
        }
        if (!this.homeDir.exists() || !this.homeDir.isDirectory()) {
            throw HostControllerMessages.MESSAGES.homeDirectoryDoesNotExist(this.homeDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)HOME_DIR, (String)this.homeDir.getAbsolutePath());
        File tmp = this.getFileFromProperty(MODULES_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "modules");
        } else if (!tmp.exists() || !tmp.isDirectory()) {
            throw HostControllerMessages.MESSAGES.modulesDirectoryDoesNotExist(tmp);
        }
        this.modulesDir = tmp;
        String deprecatedModDir = MODULES_DIR;
        WildFlySecurityManager.setPropertyPrivileged((String)deprecatedModDir, (String)this.modulesDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_BASE_DIR);
        if (tmp == null) {
            tmp = new File(this.homeDir, "domain");
        }
        if (!tmp.exists()) {
            throw HostControllerMessages.MESSAGES.domainBaseDirectoryDoesNotExist(tmp);
        }
        if (!tmp.isDirectory()) {
            throw HostControllerMessages.MESSAGES.domainBaseDirectoryIsNotADirectory(tmp);
        }
        this.domainBaseDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_BASE_DIR, (String)this.domainBaseDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_CONFIG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "configuration");
        }
        if (!tmp.exists() || !tmp.isDirectory()) {
            throw HostControllerMessages.MESSAGES.configDirectoryDoesNotExist(tmp);
        }
        this.domainConfigurationDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONFIG_DIR, (String)this.domainConfigurationDir.getAbsolutePath());
        String defaultHostConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_HOST_DEFAULT_CONFIG, (String)"host.xml");
        this.hostConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, defaultHostConfig, initialHostConfig == null ? hostConfig : initialHostConfig, initialHostConfig == null);
        String defaultDomainConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_DOMAIN_DEFAULT_CONFIG, (String)"domain.xml");
        this.domainConfigurationFile = new ConfigurationFile(this.domainConfigurationDir, defaultDomainConfig, initialDomainConfig == null ? domainConfig : initialDomainConfig, initialDomainConfig == null);
        tmp = this.getFileFromProperty(DOMAIN_DATA_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "data");
        }
        this.domainDataDir = tmp;
        if (this.domainDataDir.exists()) {
            if (!this.domainDataDir.isDirectory()) {
                throw HostControllerMessages.MESSAGES.domainDataDirectoryIsNotDirectory(this.domainDataDir);
            }
        } else if (!this.domainDataDir.mkdirs()) {
            throw HostControllerMessages.MESSAGES.couldNotCreateDomainDataDirectory(this.domainDataDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_DATA_DIR, (String)this.domainDataDir.getAbsolutePath());
        String deprecatedDepDir = DOMAIN_DEPLOYMENT_DIR;
        tmp = this.getFileFromProperty(DOMAIN_CONTENT_DIR);
        if (tmp == null) {
            tmp = this.getFileFromProperty(deprecatedDepDir);
        }
        if (tmp == null) {
            tmp = new File(this.domainDataDir, "content");
        }
        this.domainContentDir = tmp;
        if (this.domainContentDir.exists()) {
            if (!this.domainContentDir.isDirectory()) {
                throw HostControllerMessages.MESSAGES.domainContentDirectoryIsNotDirectory(this.domainContentDir);
            }
        } else if (!this.domainContentDir.mkdirs()) {
            throw HostControllerMessages.MESSAGES.couldNotCreateDomainContentDirectory(this.domainContentDir);
        }
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_CONTENT_DIR, (String)this.domainContentDir.getAbsolutePath());
        WildFlySecurityManager.setPropertyPrivileged((String)deprecatedDepDir, (String)this.domainContentDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_LOG_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "log");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerMessages.MESSAGES.logDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerMessages.MESSAGES.couldNotCreateLogDirectory(tmp);
        }
        this.domainLogDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_LOG_DIR, (String)this.domainLogDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_SERVERS_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "servers");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerMessages.MESSAGES.serversDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerMessages.MESSAGES.couldNotCreateServersDirectory(tmp);
        }
        this.domainServersDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_SERVERS_DIR, (String)this.domainServersDir.getAbsolutePath());
        tmp = this.getFileFromProperty(DOMAIN_TEMP_DIR);
        if (tmp == null) {
            tmp = new File(this.domainBaseDir, "tmp");
        }
        if (tmp.exists()) {
            if (!tmp.isDirectory()) {
                throw HostControllerMessages.MESSAGES.domainTempDirectoryIsNotADirectory(tmp);
            }
        } else if (!tmp.mkdirs()) {
            throw HostControllerMessages.MESSAGES.couldNotCreateDomainTempDirectory(tmp);
        }
        this.domainTempDir = tmp;
        WildFlySecurityManager.setPropertyPrivileged((String)DOMAIN_TEMP_DIR, (String)this.domainTempDir.getAbsolutePath());
        if (defaultJVM != null) {
            if (defaultJVM.equals("java")) {
                defaultJVM = DefaultJvmUtils.findJavaExecutable((String)DefaultJvmUtils.getCurrentJvmHome());
            }
            this.defaultJVM = new File(defaultJVM);
        } else {
            this.defaultJVM = null;
        }
        this.backupDomainFiles = backupDomainFiles;
        this.useCachedDc = useCachedDc;
        this.productConfig = productConfig;
    }

    public InetAddress getProcessControllerAddress() {
        return this.processControllerAddress;
    }

    public Integer getProcessControllerPort() {
        return this.processControllerPort;
    }

    public InetAddress getHostControllerAddress() {
        return this.hostControllerAddress;
    }

    public Integer getHostControllerPort() {
        return this.hostControllerPort;
    }

    public boolean isRestart() {
        return this.isRestart;
    }

    public boolean isBackupDomainFiles() {
        return this.backupDomainFiles;
    }

    public boolean isUseCachedDc() {
        return this.useCachedDc;
    }

    public RunningMode getInitialRunningMode() {
        return this.initialRunningMode;
    }

    public HostRunningModeControl getRunningModeControl() {
        return this.runningModeControl;
    }

    public ProductConfig getProductConfig() {
        return this.productConfig;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    @Deprecated
    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getDomainBaseDir() {
        return this.domainBaseDir;
    }

    public File getDomainConfigurationDir() {
        return this.domainConfigurationDir;
    }

    public File getDomainDataDir() {
        return this.domainDataDir;
    }

    public File getDomainContentDir() {
        return this.domainContentDir;
    }

    @Deprecated
    public File getDomainDeploymentDir() {
        return this.domainContentDir;
    }

    public File getDomainLogDir() {
        return this.domainLogDir;
    }

    public File getDomainServersDir() {
        return this.domainServersDir;
    }

    public File getDomainTempDir() {
        return this.domainTempDir;
    }

    public File getDefaultJVM() {
        return this.defaultJVM;
    }

    public Map<String, String> getHostSystemProperties() {
        return this.hostSystemProperties;
    }

    public String getQualifiedHostName() {
        return this.qualifiedHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostControllerName() {
        return this.hostControllerName;
    }

    protected String getProcessName() {
        return this.hostControllerName;
    }

    protected void setProcessName(String processName) {
        if (processName != null) {
            this.hostControllerName = processName;
        }
    }

    protected boolean isRuntimeSystemPropertyUpdateAllowed(String propertyName, String propertyValue, boolean bootTime) {
        throw HostControllerMessages.MESSAGES.hostControllerSystemPropertyUpdateNotSupported();
    }

    protected void systemPropertyUpdated(String propertyName, String propertyValue) {
    }

    public ConfigurationFile getHostConfigurationFile() {
        return this.hostConfigurationFile;
    }

    public ConfigurationFile getDomainConfigurationFile() {
        return this.domainConfigurationFile;
    }

    String getModulePath() {
        return this.modulePath;
    }

    private File getFileFromProperty(String name) {
        File relative;
        File result;
        String value = this.hostSystemProperties.get(name);
        File file = result = value != null ? new File(value) : null;
        if (result != null && this.homeDir != null && !result.exists() && !result.isAbsolute() && (relative = new File(this.homeDir, value)).exists()) {
            result = relative;
        }
        return result;
    }
}

