/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.util.Collection;
import java.util.Set;
import org.jboss.as.clustering.msc.BatchServiceTargetFactory;
import org.jboss.as.clustering.msc.ServiceBuilderFactory;
import org.jboss.as.clustering.msc.ServiceTargetFactory;
import org.jboss.msc.service.BatchServiceTarget;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

public class DelegatingServiceTarget
implements ServiceTarget {
    private final ServiceTarget target;
    private final ServiceTargetFactory factory;
    private final BatchServiceTargetFactory batchFactory;
    private final ServiceBuilderFactory builderFactory;

    public DelegatingServiceTarget(ServiceTarget target, ServiceTargetFactory factory, BatchServiceTargetFactory batchFactory, ServiceBuilderFactory builderFactory) {
        this.target = target;
        this.builderFactory = builderFactory;
        this.batchFactory = batchFactory;
        this.factory = factory;
    }

    public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) {
        return this.builderFactory.createServiceBuilder(this.target.addServiceValue(name, value));
    }

    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) {
        return this.builderFactory.createServiceBuilder(this.target.addService(name, service));
    }

    public ServiceTarget addListener(ServiceListener<Object> listener) {
        this.target.addListener(listener);
        return this;
    }

    public ServiceTarget addListener(ServiceListener<Object> ... listeners) {
        this.target.addListener(listeners);
        return this;
    }

    public ServiceTarget addListener(Collection<ServiceListener<Object>> listeners) {
        this.target.addListener(listeners);
        return this;
    }

    public ServiceTarget removeListener(ServiceListener<Object> listener) {
        this.target.removeListener(listener);
        return this;
    }

    public Set<ServiceListener<Object>> getListeners() {
        return this.target.getListeners();
    }

    public ServiceTarget addDependency(ServiceName dependency) {
        this.target.addDependency(dependency);
        return this;
    }

    public ServiceTarget addDependency(ServiceName ... dependencies) {
        this.target.addDependency(dependencies);
        return this;
    }

    public ServiceTarget addDependency(Collection<ServiceName> dependencies) {
        this.target.addDependency(dependencies);
        return this;
    }

    public ServiceTarget removeDependency(ServiceName dependency) {
        this.target.removeDependency(dependency);
        return this;
    }

    public Set<ServiceName> getDependencies() {
        return this.target.getDependencies();
    }

    public ServiceTarget subTarget() {
        return this.factory.createServiceTarget(this.target.subTarget());
    }

    public BatchServiceTarget batchTarget() {
        return this.batchFactory.createBatchServiceTarget(this.target.batchTarget());
    }

    public ServiceTarget addMonitor(StabilityMonitor monitor) {
        this.target.addMonitor(monitor);
        return this;
    }

    public ServiceTarget addMonitors(StabilityMonitor ... monitors) {
        this.target.addMonitors(monitors);
        return this;
    }

    public ServiceTarget removeMonitor(StabilityMonitor monitor) {
        this.target.removeMonitor(monitor);
        return this;
    }

    public Set<StabilityMonitor> getMonitors() {
        return this.target.getMonitors();
    }
}

