/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.remoting.impl.netty.HornetQChannelHandler;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder2;
import org.hornetq.core.remoting.impl.netty.NettyConnection;
import org.hornetq.core.remoting.impl.netty.TransportConstants;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.spi.core.remoting.AbstractConnector;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.Base64;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.HornetQThreadFactory;

public class NettyConnector
extends AbstractConnector {
    public static final String JAVAX_KEYSTORE_PATH_PROP_NAME = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_TRUSTSTORE_PATH_PROP_NAME = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.trustStorePassword";
    public static final String HORNETQ_KEYSTORE_PATH_PROP_NAME = "org.hornetq.ssl.keyStore";
    public static final String HORNETQ_KEYSTORE_PASSWORD_PROP_NAME = "org.hornetq.ssl.keyStorePassword";
    public static final String HORNETQ_TRUSTSTORE_PATH_PROP_NAME = "org.hornetq.ssl.trustStore";
    public static final String HORNETQ_TRUSTSTORE_PASSWORD_PROP_NAME = "org.hornetq.ssl.trustStorePassword";
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_HORNETQ_REMOTING_KEY = "Sec-HornetQRemoting-Key";
    public static final String SEC_HORNETQ_REMOTING_ACCEPT = "Sec-HornetQRemoting-Accept";
    public static final String HORNETQ_REMOTING = "hornetq-remoting";
    private static final AttributeKey<String> REMOTING_KEY = AttributeKey.valueOf("Sec-HornetQRemoting-Key");
    private Class<? extends Channel> channelClazz;
    private Bootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpMaxClientIdleTime;
    private final long httpClientIdleScanPeriod;
    private final boolean httpRequiresSessionId;
    private final boolean httpUpgradeEnabled;
    private final boolean useServlet;
    private final String host;
    private final int port;
    private final String localAddress;
    private final int localPort;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String enabledCipherSuites;
    private final String enabledProtocols;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final long batchDelay;
    private final ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private final String servletPath;
    private final int nioRemotingThreads;
    private final boolean useNioGlobalWorkerPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private static EventLoopGroup nioEventLoopGroup;
    private EventLoopGroup group;
    private static final Object nioWorkerPoolGuard;
    private static final AtomicInteger nioChannelFactoryCount;
    private int connectTimeoutMillis;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        super(configuration);
        if (listener == null) {
            throw HornetQClientMessageBundle.BUNDLE.nullListener();
        }
        if (handler == null) {
            throw HornetQClientMessageBundle.BUNDLE.nullHandler();
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("ssl-enabled", false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty("http-enabled", false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty("servlet-path", "/messaging/HornetQServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty("http-client-idle-time", 500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty("http-client-idle-scan-period", 500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty("http-requires-session-id", false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("http-upgrade-enabled", false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty("nio-remoting-threads", -1, configuration);
        this.useNioGlobalWorkerPool = ConfigurationHelper.getBooleanProperty("use-nio-global-worker-pool", true, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty("use-servlet", false, configuration);
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        this.localAddress = ConfigurationHelper.getStringProperty("local-address", TransportConstants.DEFAULT_LOCAL_ADDRESS, configuration);
        this.localPort = ConfigurationHelper.getIntProperty("local-port", 0, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty("key-store-path", TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("key-store-password", TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, HornetQDefaultConfiguration.getPropMaskPassword(), HornetQDefaultConfiguration.getPropMaskPassword());
            this.trustStorePath = ConfigurationHelper.getStringProperty("trust-store-path", TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty("trust-store-password", TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, HornetQDefaultConfiguration.getPropMaskPassword(), HornetQDefaultConfiguration.getPropMaskPassword());
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty("enabled-cipher-suites", TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty("enabled-protocols", TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
        } else {
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcp-no-delay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcp-send-buffer-size", 32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcp-receive-buffer-size", 32768, configuration);
        this.batchDelay = ConfigurationHelper.getLongProperty("batch-delay", 0L, configuration);
        this.connectTimeoutMillis = ConfigurationHelper.getIntProperty("connect-timeout-millis", -1, configuration);
        this.closeExecutor = closeExecutor;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public String toString() {
        return "NettyConnector [host=" + this.host + ", port=" + this.port + ", httpEnabled=" + this.httpEnabled + ", httpUpgradeEnabled=" + this.httpUpgradeEnabled + ", useServlet=" + this.useServlet + ", servletPath=" + this.servletPath + ", sslEnabled=" + this.sslEnabled + ", useNio=" + true + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        SSLContext context;
        if (this.channelClazz != null) {
            return;
        }
        int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
        if (this.useNioGlobalWorkerPool) {
            Object object = nioWorkerPoolGuard;
            synchronized (object) {
                if (nioEventLoopGroup == null) {
                    nioEventLoopGroup = new NioEventLoopGroup(threadsToUse, new HornetQThreadFactory("HornetQ-client-netty-threads", true, NettyConnector.getThisClassLoader()));
                }
                this.channelClazz = NioSocketChannel.class;
                this.group = nioEventLoopGroup;
                nioChannelFactoryCount.incrementAndGet();
            }
        } else {
            this.channelClazz = NioSocketChannel.class;
            this.group = new NioEventLoopGroup(threadsToUse);
        }
        if (this.useServlet) {
            // empty if block
        }
        this.bootstrap = new Bootstrap();
        this.bootstrap.channel(this.channelClazz);
        this.bootstrap.group(this.group);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, this.tcpNoDelay);
        if (this.connectTimeoutMillis != -1) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectTimeoutMillis);
        }
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, this.tcpSendBufferSize);
        }
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, true);
        this.bootstrap.option(ChannelOption.ALLOCATOR, new UnpooledByteBufAllocator(false));
        this.channelGroup = new DefaultChannelGroup("hornetq-connector", GlobalEventExecutor.INSTANCE);
        if (this.sslEnabled) {
            try {
                String realKeyStorePath = this.keyStorePath;
                String realKeyStorePassword = this.keyStorePassword;
                if (System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME) != null) {
                    realKeyStorePath = System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME) != null) {
                    realKeyStorePassword = System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME);
                }
                if (System.getProperty(HORNETQ_KEYSTORE_PATH_PROP_NAME) != null) {
                    realKeyStorePath = System.getProperty(HORNETQ_KEYSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(HORNETQ_KEYSTORE_PASSWORD_PROP_NAME) != null) {
                    realKeyStorePassword = System.getProperty(HORNETQ_KEYSTORE_PASSWORD_PROP_NAME);
                }
                String realTrustStorePath = this.trustStorePath;
                String realTrustStorePassword = this.trustStorePassword;
                if (System.getProperty(JAVAX_TRUSTSTORE_PATH_PROP_NAME) != null) {
                    realTrustStorePath = System.getProperty(JAVAX_TRUSTSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME) != null) {
                    realTrustStorePassword = System.getProperty(JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME);
                }
                if (System.getProperty(HORNETQ_TRUSTSTORE_PATH_PROP_NAME) != null) {
                    realTrustStorePath = System.getProperty(HORNETQ_TRUSTSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(HORNETQ_TRUSTSTORE_PASSWORD_PROP_NAME) != null) {
                    realTrustStorePassword = System.getProperty(HORNETQ_TRUSTSTORE_PASSWORD_PROP_NAME);
                }
                context = SSLSupport.createContext(realKeyStorePath, realKeyStorePassword, realTrustStorePath, realTrustStorePassword);
            }
            catch (Exception e) {
                this.close();
                IllegalStateException ise = new IllegalStateException("Unable to create NettyConnector for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        if (context == null || this.useServlet) {
            // empty if block
        }
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyConnector.this.sslEnabled && !NettyConnector.this.useServlet) {
                    SSLEngine engine = context.createSSLEngine();
                    engine.setUseClientMode(true);
                    engine.setWantClientAuth(true);
                    String[] originalProtocols = engine.getEnabledProtocols();
                    if (NettyConnector.this.enabledCipherSuites != null) {
                        try {
                            engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledCipherSuites));
                        }
                        catch (IllegalArgumentException e) {
                            HornetQClientLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedCipherSuites()));
                            throw e;
                        }
                    }
                    if (NettyConnector.this.enabledProtocols != null) {
                        try {
                            engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledProtocols));
                        }
                        catch (IllegalArgumentException e) {
                            HornetQClientLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedProtocols()));
                            throw e;
                        }
                    } else {
                        engine.setEnabledProtocols(originalProtocols);
                    }
                    SslHandler handler = new SslHandler(engine);
                    pipeline.addLast(handler);
                }
                if (NettyConnector.this.httpEnabled) {
                    pipeline.addLast(new HttpRequestEncoder());
                    pipeline.addLast(new HttpResponseDecoder());
                    pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                    pipeline.addLast(new HttpHandler());
                }
                if (NettyConnector.this.httpUpgradeEnabled) {
                    HttpClientCodec httpClientCodec = new HttpClientCodec();
                    pipeline.addLast(httpClientCodec);
                    pipeline.addLast("http-upgrade", (ChannelHandler)new HttpUpgradeHandler(pipeline, httpClientCodec));
                }
                pipeline.addLast(new HornetQFrameDecoder2());
                pipeline.addLast(new HornetQClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener()));
            }
        });
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        HornetQClientLogger.LOGGER.debug("Started Netty Connector version " + TransportConstants.NETTY_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.channelClazz == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        if (this.useNioGlobalWorkerPool) {
            Object object = nioWorkerPoolGuard;
            synchronized (object) {
                if (nioChannelFactoryCount.decrementAndGet() == 0) {
                    this.closePools();
                }
            }
        } else {
            this.group.shutdown();
        }
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    @Override
    public boolean isStarted() {
        return this.channelClazz != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection createConnection() {
        ChannelFuture future;
        Inet6Address inet6Address;
        if (this.channelClazz == null) {
            return null;
        }
        InetSocketAddress remoteDestination = new InetSocketAddress(this.host, this.port);
        InetAddress inetAddress = remoteDestination.getAddress();
        if (inetAddress instanceof Inet6Address && (inet6Address = (Inet6Address)inetAddress).getScopeId() != 0) {
            try {
                remoteDestination = new InetSocketAddress(InetAddress.getByAddress(inet6Address.getAddress()), remoteDestination.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        HornetQClientLogger.LOGGER.debug("Remote destination: " + remoteDestination);
        if (this.localPort != 0) {
            InetSocketAddress localDestination = this.localAddress != null ? new InetSocketAddress(this.localAddress, this.localPort) : new InetSocketAddress(this.localPort);
            future = this.bootstrap.connect(remoteDestination, localDestination);
        } else {
            future = this.bootstrap.connect(remoteDestination);
        }
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch;
            block16: {
                ch = future.channel();
                SslHandler sslHandler = ch.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    io.netty.util.concurrent.Future<Channel> handshakeFuture = sslHandler.handshakeFuture();
                    if (!handshakeFuture.awaitUninterruptibly(30000L)) {
                        ch.close().awaitUninterruptibly();
                        return null;
                    }
                    if (!handshakeFuture.isSuccess()) {
                        ch.close().awaitUninterruptibly();
                        HornetQClientLogger.LOGGER.errorCreatingNettyConnection(handshakeFuture.cause());
                        return null;
                    }
                    ch.pipeline().get(HornetQChannelHandler.class).active = true;
                } else {
                    if (this.httpUpgradeEnabled) {
                        try {
                            HttpUpgradeHandler httpUpgradeHandler = (HttpUpgradeHandler)ch.pipeline().get("http-upgrade");
                            URI uri = new URI("http", null, this.host, this.port, null, null, null);
                            DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath());
                            request.headers().set("Host", (Object)this.host);
                            request.headers().set("Upgrade", (Object)HORNETQ_REMOTING);
                            request.headers().set("Connection", (Object)"Upgrade");
                            byte[] nonce = NettyConnector.randomBytes(16);
                            String key = NettyConnector.base64(nonce);
                            request.headers().set(SEC_HORNETQ_REMOTING_KEY, (Object)key);
                            ch.attr(REMOTING_KEY).set(key);
                            HornetQClientLogger.LOGGER.debugf("Sending HTTP request %s", (Object)request);
                            ch.writeAndFlush(request);
                            if (!httpUpgradeHandler.awaitHandshake()) {
                                return null;
                            }
                            break block16;
                        }
                        catch (URISyntaxException e) {
                            HornetQClientLogger.LOGGER.errorCreatingNettyConnection(e);
                            return null;
                        }
                    }
                    ch.pipeline().get(HornetQChannelHandler.class).active = true;
                }
            }
            Listener connectionListener = new Listener();
            NettyConnection conn = new NettyConnection(this.configuration, ch, connectionListener, !this.httpEnabled && this.batchDelay > 0L, false);
            connectionListener.connectionCreated(null, conn, "CORE");
            return conn;
        }
        Throwable t = future.cause();
        if (t != null && !(t instanceof ConnectException)) {
            HornetQClientLogger.LOGGER.errorCreatingNettyConnection(future.cause());
        }
        return null;
    }

    @Override
    public boolean isEquivalent(Map<String, Object> configuration) {
        String host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        Integer port = ConfigurationHelper.getIntProperty("port", 5445, configuration);
        if (!port.equals(this.port)) {
            return false;
        }
        if (host.equals(this.host)) {
            return true;
        }
        boolean result = false;
        try {
            InetAddress inetAddr1 = InetAddress.getByName(host);
            InetAddress inetAddr2 = InetAddress.getByName(this.host);
            String ip1 = inetAddr1.getHostAddress();
            String ip2 = inetAddr2.getHostAddress();
            HornetQClientLogger.LOGGER.debug(this + " host 1: " + host + " ip address: " + ip1 + " host 2: " + this.host + " ip address: " + ip2);
            result = ip1.equals(ip2);
        }
        catch (UnknownHostException e) {
            HornetQClientLogger.LOGGER.error("Cannot resolve host", e);
        }
        return result;
    }

    private void closePools() {
        if (nioEventLoopGroup != null) {
            nioEventLoopGroup.shutdown();
            nioEventLoopGroup = null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Bootstrap getBootStrap() {
        return this.bootstrap;
    }

    public static void clearThreadPools() {
        if (nioEventLoopGroup != null) {
            nioEventLoopGroup.shutdown();
            nioEventLoopGroup = null;
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private static String base64(byte[] data) {
        ByteBuf encodedData = Unpooled.wrappedBuffer(data);
        ByteBuf encoded = io.netty.handler.codec.base64.Base64.encode(encodedData);
        String encodedString = encoded.toString(CharsetUtil.UTF_8);
        encoded.release();
        return encodedString;
    }

    private static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        for (int index = 0; index < size; ++index) {
            bytes[index] = (byte)NettyConnector.randomNumber(0, 255);
        }
        return bytes;
    }

    private static int randomNumber(int minimum, int maximum) {
        return (int)(Math.random() * (double)maximum + (double)minimum);
    }

    public static String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
        try {
            String concat = secretKey + magicNumber;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes("UTF-8"));
            byte[] bytes = digest.digest();
            return Base64.encodeBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    static {
        ResourceLeakDetector.setEnabled(false);
        nioWorkerPoolGuard = new Object();
        nioChannelFactoryCount = new AtomicInteger(0);
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyConnector.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(HornetQComponent component, Connection connection, String protocol) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw HornetQClientMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            String handshake = "HORNETQ";
            HornetQBuffer buffer = connection.createBuffer(handshake.length());
            buffer.writeBytes(handshake.getBytes());
            connection.write(buffer);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                NettyConnector.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(final Object connectionID, final HornetQException me) {
            NettyConnector.this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }

    class HttpHandler
    extends ChannelDuplexHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private HttpIdleTimer task;
        private final String url;
        private final FutureLatch handShakeFuture = new FutureLatch();
        private boolean active = false;
        private boolean handshaking = false;
        private String cookie;

        public HttpHandler() throws Exception {
            this.url = new URI("http", null, NettyConnector.this.host, NettyConnector.this.port, NettyConnector.this.servletPath, null, null).toString();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.channel = ctx.channel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.task = new HttpIdleTimer();
                ScheduledFuture<?> future = NettyConnector.this.scheduledThreadPool.scheduleAtFixedRate(this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod, TimeUnit.MILLISECONDS);
                this.task.setFuture(future);
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.task != null) {
                this.task.close();
            }
            super.channelInactive(ctx);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                Set<Cookie> cookieMap = CookieDecoder.decode(response.headers().get("Set-Cookie"));
                for (Cookie cookie : cookieMap) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.cookie = ClientCookieEncoder.encode(cookie);
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            this.waitingGet = false;
            ctx.fireChannelRead(response.content());
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                ByteBuf buf = (ByteBuf)msg;
                DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url, buf);
                httpRequest.headers().add("Host", (Object)NettyConnector.this.host);
                if (this.cookie != null) {
                    httpRequest.headers().add("Cookie", (Object)this.cookie);
                }
                httpRequest.headers().add("Content-Length", (Object)String.valueOf(buf.readableBytes()));
                ctx.write(httpRequest, promise);
                this.lastSendTime = System.currentTimeMillis();
            } else {
                ctx.write(msg, promise);
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        private class HttpIdleTimer
        implements Runnable {
            private boolean closed = false;
            private Future<?> future;

            private HttpIdleTimer() {
            }

            @Override
            public synchronized void run() {
                if (this.closed) {
                    return;
                }
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    httpRequest.headers().add("Host", (Object)NettyConnector.this.host);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.writeAndFlush(httpRequest);
                }
            }

            public synchronized void setFuture(Future<?> future) {
                this.future = future;
            }

            public void close() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.closed = true;
            }
        }
    }

    private static class HttpUpgradeHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private final ChannelPipeline pipeline;
        private final HttpClientCodec httpClientCodec;
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean handshakeComplete = false;

        public HttpUpgradeHandler(ChannelPipeline pipeline, HttpClientCodec httpClientCodec) {
            this.pipeline = pipeline;
            this.httpClientCodec = httpClientCodec;
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                if (response.getStatus().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && response.headers().get("Upgrade").equals(NettyConnector.HORNETQ_REMOTING)) {
                    String accept = response.headers().get(NettyConnector.SEC_HORNETQ_REMOTING_ACCEPT);
                    String expectedResponse = NettyConnector.createExpectedResponse(NettyConnector.MAGIC_NUMBER, (String)ctx.channel().attr(REMOTING_KEY).get());
                    if (expectedResponse.equals(accept)) {
                        this.pipeline.remove(this.httpClientCodec);
                        this.pipeline.remove(this);
                        this.handshakeComplete = true;
                        this.pipeline.get(HornetQChannelHandler.class).active = true;
                    } else {
                        HornetQClientLogger.LOGGER.httpHandshakeFailed(accept, expectedResponse);
                        ctx.close();
                    }
                }
                this.latch.countDown();
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            HornetQClientLogger.LOGGER.errorCreatingNettyConnection(cause);
            ctx.close();
        }

        public boolean awaitHandshake() {
            try {
                if (!this.latch.await(30000L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return this.handshakeComplete;
        }
    }

    private static final class HornetQClientChannelHandler
    extends HornetQChannelHandler {
        HornetQClientChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }
    }
}

