/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ModelNodeFormatter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.dmr.ModelNode;

public class ReadAttributeHandler
extends BaseOperationCommand {
    private final ArgumentWithValue node = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, "--node");
    private final ArgumentWithValue name = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        public List<String> getAllCandidates(CommandContext ctx) {
            try {
                OperationRequestAddress address = ReadAttributeHandler.this.getAddress(ctx);
                ModelNode req = new ModelNode();
                if (address.isEmpty()) {
                    req.get("address").setEmptyList();
                } else {
                    if (address.endsOnType()) {
                        return Collections.emptyList();
                    }
                    ModelNode addrNode = req.get("address");
                    for (OperationRequestAddress.Node node : address) {
                        addrNode.add(node.getType(), node.getName());
                    }
                }
                req.get("operation").set("read-resource-description");
                try {
                    ModelNode response = ctx.getModelControllerClient().execute(req);
                    if (Util.isSuccess(response)) {
                        if (response.hasDefined("result")) {
                            ModelNode result = response.get("result");
                            if (result.hasDefined("attributes")) {
                                Set<String> attributes = result.get("attributes").keys();
                                if (attributes.isEmpty()) {
                                    return Collections.emptyList();
                                }
                                ArrayList<String> candidates = new ArrayList<String>(attributes.size());
                                candidates.addAll(attributes);
                                return candidates;
                            }
                            return Collections.emptyList();
                        }
                        return Collections.emptyList();
                    }
                    return Collections.emptyList();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (CommandFormatException e) {
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
    }), 0, "--name");
    private final ArgumentWithValue includeDefaults = new ArgumentWithValue((CommandHandlerWithArguments)this, SimpleTabCompleter.BOOLEAN, "--include-defaults");
    private final ArgumentWithoutValue verbose = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--verbose", "-v");

    public ReadAttributeHandler(CommandContext ctx) {
        super(ctx, "read-attribute", true);
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String name = this.name.getValue(parsedCmd);
        if (name == null || name.isEmpty()) {
            throw new CommandFormatException("Required argument " + this.name.getFullName() + " is not specified.");
        }
        OperationRequestAddress address = this.getAddress(ctx);
        ModelNode req = Util.buildRequest(ctx, address, "read-attribute");
        req.get("name").set(name);
        String includeDefaults = this.includeDefaults.getValue(parsedCmd);
        if (includeDefaults != null && !includeDefaults.isEmpty()) {
            req.get("include-defaults").set(includeDefaults);
        }
        if (this.verbose.isPresent(parsedCmd)) {
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            steps.add(req);
            steps.add(Util.buildRequest(ctx, address, "read-resource-description"));
            req = composite;
        }
        return req;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandFormatException {
        if (!Util.isSuccess(response)) {
            throw new CommandFormatException(Util.getFailureDescription(response));
        }
        if (!response.hasDefined("result")) {
            return;
        }
        ModelNode result = response.get("result");
        if (composite) {
            ModelNode stepOutcome;
            SimpleTable table = new SimpleTable(2);
            StringBuilder valueBuf = new StringBuilder();
            if (result.hasDefined("step-1")) {
                stepOutcome = result.get("step-1");
                if (!Util.isSuccess(stepOutcome)) throw new CommandFormatException("Failed to get resource description: " + response);
                if (stepOutcome.hasDefined("result")) {
                    ModelNode valueResult = stepOutcome.get("result");
                    ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(valueResult.getType());
                    formatter.format(valueBuf, 0, valueResult);
                } else {
                    valueBuf.append("n/a");
                }
                table.addLine(new String[]{"value", valueBuf.toString()});
            }
            if (result.hasDefined("step-2")) {
                stepOutcome = result.get("step-2");
                if (!Util.isSuccess(stepOutcome)) throw new CommandFormatException("Failed to get resource description: " + response);
                if (!stepOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-resource-description request: " + response);
                ModelNode descrResult = stepOutcome.get("result");
                if (!descrResult.hasDefined("attributes")) throw new CommandFormatException("The resource doesn't provide attribute descriptions.");
                ModelNode attributes = descrResult.get("attributes");
                String name = this.name.getValue(ctx.getParsedCommandLine());
                if (name == null) {
                    throw new CommandFormatException("Attribute name is not available in handleResponse.");
                }
                if (!attributes.hasDefined(name)) throw new CommandFormatException("Attribute description is not available.");
                ModelNode descr = attributes.get(name);
                for (String prop : descr.keys()) {
                    table.addLine(new String[]{prop, descr.get(prop).asString()});
                }
            }
            ctx.printLine(table.toString(true));
            return;
        } else {
            ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(result.getType());
            StringBuilder buf = new StringBuilder();
            formatter.format(buf, 0, result);
            ctx.printLine(buf.toString());
        }
    }

    protected StringBuilder formatResponse(CommandContext ctx, ModelNode opResponse, boolean composite, StringBuilder buf) throws CommandFormatException {
        if (!opResponse.hasDefined("result")) {
            return null;
        }
        ModelNode result = opResponse.get("result");
        if (composite) {
            Set<String> keys;
            try {
                keys = result.keys();
            }
            catch (Exception e) {
                throw new CommandFormatException("Failed to get step results from a composite operation response " + opResponse);
            }
            for (String key : keys) {
                ModelNode stepResponse = result.get(key);
                buf = this.formatResponse(ctx, stepResponse, false, buf);
            }
        } else {
            ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(result.getType());
            if (buf == null) {
                buf = new StringBuilder();
            }
            formatter.format(buf, 0, result);
        }
        return buf;
    }

    protected OperationRequestAddress getAddress(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestAddress address;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.node.isPresent(args)) {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
            DefaultCallbackHandler handler = new DefaultCallbackHandler(address);
            String nodePath = args.getOriginalLine();
            int nodeArgInd = nodePath.indexOf(" --node=");
            if (nodeArgInd < 0) {
                throw new CommandFormatException("Couldn't locate ' --node=' in the line: '" + nodePath + "'");
            }
            int nodeArgEndInd = nodeArgInd + 8;
            do {
                if ((nodeArgEndInd = nodePath.indexOf(32, nodeArgEndInd)) < 0) {
                    nodeArgEndInd = nodePath.length();
                    continue;
                }
                if (nodePath.charAt(nodeArgEndInd - 1) != '\\') break;
                ++nodeArgEndInd;
            } while (nodeArgEndInd < nodePath.length());
            nodePath = nodePath.substring(nodeArgInd + 8, nodeArgEndInd);
            ctx.getCommandLineParser().parse(nodePath, handler);
        } else {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
        }
        return address;
    }
}

