/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.net.URL;
import javax.resource.spi.ResourceAdapter;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ResourceAdapterXmlDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)"org.jboss.as.connector.deployers.RaXmlDeployer");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter raxml;
    private final String deployment;
    private String raName;
    private ServiceName deploymentServiceName;
    private CommonDeployment raxmlDeployment = null;
    private final ServiceName duServiceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceAdapterXmlDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter raxml, Module module, String deployment, ServiceName deploymentServiceName, ServiceName duServiceName) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        ResourceAdapterXmlDeploymentService resourceAdapterXmlDeploymentService = this;
        synchronized (resourceAdapterXmlDeploymentService) {
            this.raxml = raxml;
        }
        this.module = module;
        this.deployment = deployment;
        this.raName = deployment;
        this.deploymentServiceName = deploymentServiceName;
        this.duServiceName = duServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.deployment);
            File root = ((AS7MetadataRepository)this.mdr.getValue()).getRoot(this.deployment);
            org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter localRaXml = this.getRaxml();
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)localRaXml, cmd);
            AS7RaXmlDeployer raDeployer = new AS7RaXmlDeployer(context.getChildTarget(), this.connectorXmlDescriptor.getUrl(), this.raName, root, (ClassLoader)this.module.getClassLoader(), cmd, localRaXml, null, this.deploymentServiceName);
            raDeployer.setConfiguration((Configuration)this.config.getValue());
            try {
                WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
                ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.module.getClassLoader());
                    this.raxmlDeployment = raDeployer.doDeploy();
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                    WritableServiceBasedNamingStore.popOwner();
                }
            }
            catch (Throwable t) {
                this.cleanupStartAsync(context, this.raName, t);
                return;
            }
            String id = ((ModifiableResourceAdapter)this.raxml).getId();
            ServiceName raServiceName = id == null || id.trim().isEmpty() ? ConnectorServices.getResourceAdapterServiceName(this.raName) : ConnectorServices.getResourceAdapterServiceName(id);
            this.value = new ResourceAdapterDeployment(this.raxmlDeployment, this.raName, raServiceName);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(this.raName, raServiceName, this.value.getDeployment().getResourceAdapter())).addDependency(this.deploymentServiceName).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.stopAsync(context, this.raName, this.deploymentServiceName);
    }

    @Override
    public void unregisterAll(String deploymentName) {
        if (this.raName != null) {
            ConnectorServices.unregisterResourceAdapterIdentifier(this.raName);
        }
        super.unregisterAll(deploymentName);
    }

    public CommonDeployment getRaxmlDeployment() {
        return this.raxmlDeployment;
    }

    public synchronized void setRaxml(org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter raxml) {
        this.raxml = raxml;
    }

    public synchronized org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter getRaxml() {
        return this.raxml;
    }

    private class AS7RaXmlDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter ra;
        private final IronJacamar ijmd;

        public AS7RaXmlDeployer(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter ra, IronJacamar ijmd, ServiceName deploymentServiceName) {
            super(serviceTarget, url, deploymentName, root, cl, cmd, deploymentServiceName);
            this.ra = ra;
            this.ijmd = ijmd;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterXmlDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.ijmd, this.ra);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            return true;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }

        @Override
        protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
            String raIdentifier = ((ResourceAdapterRepository)ResourceAdapterXmlDeploymentService.this.raRepository.getValue()).registerResourceAdapter(instance);
            ConnectorServices.registerResourceAdapterIdentifier(((ModifiableResourceAdapter)ResourceAdapterXmlDeploymentService.this.raxml).getId(), raIdentifier);
            return raIdentifier;
        }
    }
}

