/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceStatisticsListener;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueInjectionService;
import org.jboss.security.SubjectFactory;

public abstract class AbstractDataSourceAdd
extends AbstractAddStepHandler {
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean enabled;
        final Resource resource = this.createResource(context);
        this.populateModel(context, operation, resource);
        final ModelNode model = resource.getModel();
        boolean bl = enabled = !operation.hasDefined(Constants.ENABLED.getName()) || operation.get(Constants.ENABLED.getName()).asBoolean();
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    AbstractDataSourceAdd.this.performRuntime(context, operation, resource, model, verificationHandler, controllers);
                    if (AbstractDataSourceAdd.this.requiresRuntimeVerification()) {
                        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractDataSourceAdd.this.rollbackRuntime(context, operation, model, controllers);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        if (enabled) {
            context.addStep((OperationStepHandler)new DataSourceEnable(this instanceof XaDataSourceAdd), OperationContext.Stage.MODEL);
        }
        context.stepCompleted();
    }

    protected final void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    private void performRuntime(OperationContext context, ModelNode operation, Resource resource, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        String jndiName = model.get(Constants.JNDI_NAME.getName()).asString();
        boolean jta = Constants.JTA.resolveModelAttribute(context, operation).asBoolean();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode node = Constants.DATASOURCE_DRIVER.resolveModelAttribute(context, model);
        String driverName = node.asString();
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        ValueInjectionService driverDemanderService = new ValueInjectionService();
        ServiceName driverDemanderServiceName = ServiceName.JBOSS.append(new String[]{"driver-demander"}).append(new String[]{jndiName});
        ServiceBuilder driverDemanderBuilder = serviceTarget.addService(driverDemanderServiceName, (Service)driverDemanderService).addDependency(driverServiceName, Driver.class, driverDemanderService.getInjector());
        driverDemanderBuilder.addListener((ServiceListener)verificationHandler);
        driverDemanderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        AbstractDataSourceService dataSourceService = this.createDataSourceService(dsName);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder dataSourceServiceBuilder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService), dataSourceService.getExecutorServiceInjector(), (boolean)false).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME);
        if (jta) {
            dataSourceServiceBuilder.addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector());
        }
        ManagementResourceRegistration overrideRegistration = registration.isAllowsOverride() ? registration.registerOverrideModel(dsName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC) : registration;
        dataSourceServiceBuilder.addListener((ServiceListener)new DataSourceStatisticsListener(overrideRegistration, resource, dsName));
        dataSourceServiceBuilder.addListener((ServiceListener)verificationHandler);
        this.startConfigAndAddDependency(dataSourceServiceBuilder, dataSourceService, dsName, serviceTarget, operation, verificationHandler);
        dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER);
        controllers.add(dataSourceServiceBuilder.install());
        controllers.add(driverDemanderBuilder.install());
    }

    protected abstract void startConfigAndAddDependency(ServiceBuilder<?> var1, AbstractDataSourceService var2, String var3, ServiceTarget var4, ModelNode var5, ServiceVerificationHandler var6) throws OperationFailedException;

    protected abstract void populateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected abstract AbstractDataSourceService createDataSourceService(String var1) throws OperationFailedException;

    static void populateAddModel(ModelNode operation, ModelNode modelNode, String connectionPropertiesProp, SimpleAttributeDefinition[] attributes, PropertiesAttributeDefinition[] properties) throws OperationFailedException {
        if (operation.hasDefined(connectionPropertiesProp)) {
            for (Property property : operation.get(connectionPropertiesProp).asPropertyList()) {
                modelNode.get(new String[]{connectionPropertiesProp, property.getName()}).set(property.getValue().asString());
            }
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.validateAndSet(operation, modelNode);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : properties) {
            simpleAttributeDefinition.validateAndSet(operation, modelNode);
        }
    }
}

