/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.api.workmanager.WorkManagerStatistics;

public class WorkManagerRuntimeAttributeReadHandler
implements OperationStepHandler {
    private final WorkManagerStatistics wmStat;
    private final WorkManager wm;

    public WorkManagerRuntimeAttributeReadHandler(WorkManager wm, WorkManagerStatistics wmStat) {
        this.wm = wm;
        this.wmStat = wmStat;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String attributeName = operation.require("name").asString();
                    try {
                        ModelNode result = context.getResult();
                        switch (attributeName) {
                            case "work-active": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getWorkActive());
                                break;
                            }
                            case "work-failed": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getWorkFailed());
                                break;
                            }
                            case "work-successful": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getWorkSuccessful());
                                break;
                            }
                            case "dowork-accepted": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getDoWorkAccepted());
                                break;
                            }
                            case "dowork-rejected": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getDoWorkRejected());
                                break;
                            }
                            case "schedulework-accepted": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getScheduleWorkAccepted());
                                break;
                            }
                            case "schedulework-rejected": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getScheduleWorkRejected());
                                break;
                            }
                            case "startwork-accepted": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getStartWorkAccepted());
                                break;
                            }
                            case "startwork-rejected": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wmStat.getStartWorkRejected());
                                break;
                            }
                            case "workmanager-statistics-enabled": {
                                result.set(WorkManagerRuntimeAttributeReadHandler.this.wm.isStatisticsEnabled());
                                break;
                            }
                            case "distributed-workmanager-statistics-enabled": {
                                result.set(((DistributedWorkManager)WorkManagerRuntimeAttributeReadHandler.this.wm).isDistributedStatisticsEnabled());
                                break;
                            }
                            case "dowork-distribution-enabled": {
                                result.set(((DistributedWorkManager)WorkManagerRuntimeAttributeReadHandler.this.wm).isDoWorkDistributionEnabled());
                                break;
                            }
                            case "startwork-distribution-enabled": {
                                result.set(((DistributedWorkManager)WorkManagerRuntimeAttributeReadHandler.this.wm).isStartWorkDistributionEnabled());
                                break;
                            }
                            case "schedulework-distribution-enabled": {
                                result.set(((DistributedWorkManager)WorkManagerRuntimeAttributeReadHandler.this.wm).isScheduleWorkDistributionEnabled());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new OperationFailedException(ConnectorMessages.MESSAGES.failedToGetMetrics(e.getLocalizedMessage()));
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

