/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.msc.service.ServiceName;

public class ConnectorServices {
    private static Map<String, String> resourceAdapterRepositoryIdentifiers = new HashMap<String, String>();
    public static final ServiceName CONNECTOR_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "config"});
    public static final ServiceName BEAN_VALIDATION_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "bean_validation", "config"});
    public static final ServiceName ARCHIVE_VALIDATION_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "archive_validation", "config"});
    public static final ServiceName BOOTSTRAP_CONTEXT_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "bootstrapcontext"});
    public static final ServiceName TRANSACTION_INTEGRATION_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "transactionintegration"});
    public static final ServiceName WORKMANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "workmanager"});
    public static final ServiceName RESOURCE_ADAPTER_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"ra"});
    public static final ServiceName RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{"deployment"});
    public static final ServiceName RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{"deployer"});
    public static final ServiceName RESOURCE_ADAPTER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"raregistry"});
    public static final ServiceName RESOURCE_ADAPTER_ACTIVATOR_SERVICE = ServiceName.JBOSS.append(new String[]{"raactivator"});
    public static final ServiceName INACTIVE_RESOURCE_ADAPTER_SERVICE = ServiceName.JBOSS.append(new String[]{"rainactive"});
    public static final ServiceName IRONJACAMAR_MDR = ServiceName.JBOSS.append(new String[]{"ironjacamar", "mdr"});
    public static final ServiceName RA_REPOSITORY_SERVICE = ServiceName.JBOSS.append(new String[]{"rarepository"});
    public static final ServiceName MANAGEMENT_REPOSITORY_SERVICE = ServiceName.JBOSS.append(new String[]{"management_repository"});
    public static final ServiceName RESOURCEADAPTERS_SERVICE = ServiceName.JBOSS.append(new String[]{"resourceadapters"});
    public static final ServiceName RA_SERVICE = ServiceName.JBOSS.append(new String[]{"resourceadapters", "ra"});
    public static final ServiceName DATASOURCES_SERVICE = ServiceName.JBOSS.append(new String[]{"datasources"});
    public static final ServiceName JDBC_DRIVER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"jdbc-driver", "registry"});
    public static final ServiceName CCM_SERVICE = ServiceName.JBOSS.append(new String[]{"cached-connection-manager"});
    public static final ServiceName IDLE_REMOVER_SERVICE = ServiceName.JBOSS.append(new String[]{"ironjacamar", "idle-remover"});
    public static final ServiceName CONNECTION_VALIDATOR_SERVICE = ServiceName.JBOSS.append(new String[]{"ironjacamar", "connection-validator"});

    public static <T> T notNull(T value) {
        if (value == null) {
            throw ConnectorMessages.MESSAGES.serviceNotStarted();
        }
        return value;
    }

    public static synchronized ServiceName getDeploymentServiceName(String raName, ResourceAdapter raxml) {
        if (raName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        ServiceName serviceName = null;
        ModifiableResourceAdapter ra = (ModifiableResourceAdapter)raxml;
        serviceName = ra != null && ra.getId() != null ? ConnectorServices.getDeploymentServiceName(raName, ra.getId()) : ConnectorServices.getDeploymentServiceName(raName, (String)null);
        ConnectorLogger.ROOT_LOGGER.tracef("ConnectorServices: getDeploymentServiceName(%s,%s) -> %s", raName, raxml, serviceName);
        return serviceName;
    }

    public static synchronized ServiceName getDeploymentServiceName(String raName, String raId) {
        if (raName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        ServiceName serviceName = null;
        serviceName = raId == null || raId.equals(raName) ? RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX.append(new String[]{raName}) : RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX.append(new String[]{raName + "_" + raId});
        ConnectorLogger.ROOT_LOGGER.tracef("ConnectorServices: getDeploymentServiceName(%s,%s) -> %s", raName, raId, serviceName);
        return serviceName;
    }

    public static synchronized ServiceName getDeploymentServiceName(String raName) {
        if (raName == null) {
            throw ConnectorMessages.MESSAGES.undefinedVar("RaName");
        }
        ServiceName serviceName = RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX.append(new String[]{raName});
        ConnectorLogger.ROOT_LOGGER.tracef("ConnectorServices: getDeploymentServiceName(%s) -> %s", raName, serviceName);
        return serviceName;
    }

    public static synchronized ServiceName getResourceAdapterServiceName(String id) {
        if (id == null || id.trim().isEmpty()) {
            throw ConnectorMessages.MESSAGES.undefinedVar("id");
        }
        ServiceName serviceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{ConnectorServices.stripDotRarSuffix(id)});
        ConnectorLogger.ROOT_LOGGER.tracef("ConnectorServices: getResourceAdapterServiceName(%s) -> %s", id, serviceName);
        return serviceName;
    }

    private static String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegisteredResourceAdapterIdentifier(String raName) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            return resourceAdapterRepositoryIdentifiers.get(raName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResourceAdapterIdentifier(String raName, String raIdentifier) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            resourceAdapterRepositoryIdentifiers.put(raName, raIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResourceAdapterIdentifier(String raName) {
        Map<String, String> map = resourceAdapterRepositoryIdentifiers;
        synchronized (map) {
            resourceAdapterRepositoryIdentifiers.remove(raName);
        }
    }
}

