/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.TransactionAwareObjectFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulAllowedMethodsInformation;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.security.manager.WildFlySecurityManager;

public class StatefulSessionComponent
extends SessionBeanComponent
implements StatefulObjectFactory<StatefulSessionComponentInstance>,
PassivationListener<StatefulSessionComponentInstance>,
IdentifierFactory<SessionID> {
    public static final Object SESSION_ID_REFERENCE_KEY = new Object();
    private volatile Cache<SessionID, StatefulSessionComponentInstance> cache;
    private final InterceptorFactory afterBegin;
    private Interceptor afterBeginInterceptor;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private Interceptor afterCompletionInterceptor;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private Interceptor beforeCompletionInterceptor;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private Interceptor prePassivateInterceptor;
    private final InterceptorFactory postActivate;
    private Interceptor postActivateInterceptor;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodAccessTimeouts;
    private final DefaultAccessTimeoutService defaultAccessTimeoutProvider;
    private final Value<CacheFactory> cacheFactory;
    private final InterceptorFactory ejb2XRemoveMethod;
    private Interceptor ejb2XRemoveMethodInterceptor;
    private final Set<Object> serialiableInterceptorContextKeys;
    private final TimerService timerService;

    protected StatefulSessionComponent(StatefulSessionComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.afterBegin = ejbComponentCreateService.getAfterBegin();
        this.afterBeginMethod = ejbComponentCreateService.getAfterBeginMethod();
        this.afterCompletion = ejbComponentCreateService.getAfterCompletion();
        this.afterCompletionMethod = ejbComponentCreateService.getAfterCompletionMethod();
        this.beforeCompletion = ejbComponentCreateService.getBeforeCompletion();
        this.beforeCompletionMethod = ejbComponentCreateService.getBeforeCompletionMethod();
        this.prePassivate = ejbComponentCreateService.getPrePassivate();
        this.postActivate = ejbComponentCreateService.getPostActivate();
        this.methodAccessTimeouts = ejbComponentCreateService.getMethodApplicableAccessTimeouts();
        this.defaultAccessTimeoutProvider = ejbComponentCreateService.getDefaultAccessTimeoutService();
        this.ejb2XRemoveMethod = ejbComponentCreateService.getEjb2XRemoveMethod();
        this.serialiableInterceptorContextKeys = ejbComponentCreateService.getSerializableInterceptorContextKeys();
        this.timerService = ejbComponentCreateService.getTimerService();
        this.cacheFactory = ejbComponentCreateService.getCacheFactory();
    }

    @Override
    public StatefulSessionComponentInstance createInstance() {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    public StatefulSessionComponentInstance createInstance(Object instance) {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    protected StatefulSessionComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct) {
        return (StatefulSessionComponentInstance)super.constructComponentInstance(instance, invokePostConstruct);
    }

    protected StatefulSessionComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct, Map<Object, Object> context) {
        return (StatefulSessionComponentInstance)super.constructComponentInstance(instance, invokePostConstruct, context);
    }

    @Override
    public void destroyInstance(StatefulSessionComponentInstance instance) {
        instance.destroy();
    }

    public void postActivate(StatefulSessionComponentInstance instance) {
        instance.postActivate();
    }

    public void prePassivate(StatefulSessionComponentInstance instance) {
        instance.prePassivate();
    }

    protected SessionID getSessionIdOf(InterceptorContext ctx) {
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)ctx.getPrivateData(ComponentInstance.class);
        return instance.getId();
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface, InterceptorContext context) throws IllegalStateException {
        if (businessInterface == null) {
            throw EjbMessages.MESSAGES.businessInterfaceIsNull();
        }
        return this.createViewInstanceProxy(businessInterface, Collections.singletonMap(SessionID.class, this.getSessionIdOf(context)));
    }

    @Override
    public EJBLocalObject getEJBLocalObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbLocalObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.ejbLocalObjectUnavailable(this.getComponentName());
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.singletonMap(SessionID.class, this.getSessionIdOf(ctx)), this.getEjbLocalObjectViewServiceName());
    }

    @Override
    public EJBObject getEJBObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        ServiceController serviceController = StatefulSessionComponent.currentServiceContainer().getRequiredService(this.getEjbObjectViewServiceName());
        ComponentView view = (ComponentView)serviceController.getValue();
        String locatorAppName = this.getEarApplicationName() == null ? "" : this.getEarApplicationName();
        return (EJBObject)EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(view.getViewClass(), locatorAppName, this.getModuleName(), this.getComponentName(), this.getDistinctName(), this.getSessionIdOf(ctx), this.getCache().getStrictAffinity(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null)));
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        return this.timerService;
    }

    public AccessTimeoutDetails getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeoutDetails accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeoutDetails timeout = (AccessTimeoutDetails)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (timeout != null) {
            return timeout;
        }
        return this.defaultAccessTimeoutProvider.getDefaultAccessTimeout();
    }

    public SessionID createSession() {
        return this.cache.create().getId();
    }

    public Cache<SessionID, StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    public SessionID createIdentifier() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return SessionID.createSessionID((byte[])bb.array());
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        StatefulSessionComponentInstance instance = new StatefulSessionComponentInstance(this, preDestroyInterceptor, methodInterceptors, context);
        for (Object key : this.serialiableInterceptorContextKeys) {
            instance.setInstanceData(key, context.get(key));
        }
        instance.setInstanceData(BasicComponentInstance.INSTANCE_KEY, context.get(BasicComponentInstance.INSTANCE_KEY));
        return instance;
    }

    public void removeSession(SessionID sessionId) {
        this.cache.remove(sessionId);
    }

    public Interceptor getAfterBegin() {
        return this.afterBeginInterceptor;
    }

    public Interceptor getAfterCompletion() {
        return this.afterCompletionInterceptor;
    }

    public Interceptor getBeforeCompletion() {
        return this.beforeCompletionInterceptor;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public Interceptor getPrePassivate() {
        return this.prePassivateInterceptor;
    }

    public Interceptor getPostActivate() {
        return this.postActivateInterceptor;
    }

    public Interceptor getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethodInterceptor;
    }

    @Override
    public void start() {
        this.getShutDownInterceptorFactory().start();
        super.start();
        this.cache = ((CacheFactory)this.cacheFactory.getValue()).createCache(this, new TransactionAwareObjectFactory<StatefulSessionComponentInstance>(this, this.getTransactionManager()), this);
        this.cache.start();
    }

    protected void createInterceptors(InterceptorFactoryContext context) {
        super.createInterceptors(context);
        if (this.afterBegin != null) {
            this.afterBeginInterceptor = this.afterBegin.create(context);
        }
        if (this.afterCompletion != null) {
            this.afterCompletionInterceptor = this.afterCompletion.create(context);
        }
        if (this.beforeCompletion != null) {
            this.beforeCompletionInterceptor = this.beforeCompletion.create(context);
        }
        if (this.prePassivate != null) {
            this.prePassivateInterceptor = this.prePassivate.create(context);
        }
        if (this.postActivate != null) {
            this.postActivateInterceptor = this.postActivate.create(context);
        }
        if (this.ejb2XRemoveMethod != null) {
            this.ejb2XRemoveMethodInterceptor = this.ejb2XRemoveMethod.create(context);
        }
    }

    @Override
    public void stop() {
        this.getShutDownInterceptorFactory().shutdown();
        super.stop();
        this.cache.stop();
        this.cache = null;
        this.afterBeginInterceptor = null;
        this.afterCompletionInterceptor = null;
        this.beforeCompletionInterceptor = null;
        this.prePassivateInterceptor = null;
        this.postActivateInterceptor = null;
        this.ejb2XRemoveMethodInterceptor = null;
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? StatefulAllowedMethodsInformation.INSTANCE_BMT : StatefulAllowedMethodsInformation.INSTANCE_CMT;
    }

    public Set<Object> getSerialiableInterceptorContextKeys() {
        return this.serialiableInterceptorContextKeys;
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }
}

