/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.jboss.as.jpa.container.QueryNonTxInvocationDetacher;
import org.jboss.as.jpa.container.TypedQueryNonTxInvocationDetacher;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.messages.JpaMessages;

public abstract class AbstractEntityManager
implements EntityManager {
    private final transient boolean isTraceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();

    protected abstract EntityManager getEntityManager();

    protected abstract boolean isExtendedPersistenceContext();

    protected abstract boolean isInTx();

    public abstract SynchronizationType getSynchronizationType();

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEntityManager().unwrap(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            TypedQuery typedQuery = this.detachTypedQueryNonTxInvocation(entityManager, entityManager.createNamedQuery(name, resultClass));
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNamedQuery name '%s', resultClass '%s' took %dms", name, resultClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            TypedQuery typedQuery = this.detachTypedQueryNonTxInvocation(entityManager, entityManager.createQuery(criteriaQuery));
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            TypedQuery typedQuery = this.detachTypedQueryNonTxInvocation(entityManager, entityManager.createQuery(qlString, resultClass));
            return typedQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery resultClass '%s' took %dms", resultClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().detach(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("detach entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, properties);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s' took %dms", entityClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, lockMode);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s', lockMode '%s' took %dms", entityClass.getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = underlyingEntityManager.find(entityClass, primaryKey, lockMode, properties);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s', lockMode '%s' took %dms", entityClass.getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = this.getEntityManager().find(entityClass, primaryKey);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("find entityClass '%s' took %dms", entityClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getCriteriaBuilder took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManagerFactory entityManagerFactory = this.getEntityManager().getEntityManagerFactory();
            return entityManagerFactory;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getEntityManagerFactory took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        LockModeType result = null;
        try {
            result = this.getEntityManager().getLockMode(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getLockMode entityClass '%s', lockMode '%s'  took %dms", entity.getClass().getName(), AbstractEntityManager.getLockModeAsString(result), elapsed);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Metamodel metamodel = this.getEntityManager().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getMetamodel took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Map map = this.getEntityManager().getProperties();
            return map;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getProperties took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().lock(entity, lockMode, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("lock entityClass '%s', lockMode '%s'  took %dms", entity.getClass().getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().setProperty(propertyName, value);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("setProperty took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().clear();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("clear took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().close();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("close took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            boolean bl = this.getEntityManager().contains(entity);
            return bl;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("contains '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = this.detachQueryNonTxInvocation(entityManager, entityManager.createNamedQuery(name));
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNamedQuery name '%s' took %dms", name, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = this.detachQueryNonTxInvocation(entityManager, entityManager.createNativeQuery(sqlString, resultClass));
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery resultClass '%s' took %dms", resultClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = this.detachQueryNonTxInvocation(entityManager, entityManager.createNativeQuery(sqlString, resultSetMapping));
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = this.detachQueryNonTxInvocation(entityManager, entityManager.createNativeQuery(sqlString));
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNativeQuery took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String ejbqlString) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = this.detachQueryNonTxInvocation(entityManager, entityManager.createQuery(ejbqlString));
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().flush();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("flush took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Object object = this.getEntityManager().getDelegate();
            return object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getDelegate took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            FlushModeType flushModeType = this.getEntityManager().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getFlushMode took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityManager underlyingEntityManager = this.getEntityManager();
            Object result = this.getEntityManager().getReference(entityClass, primaryKey);
            this.detachNonTxInvocation(underlyingEntityManager);
            Object object = result;
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getReference entityClass '%s' took %dms", entityClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityTransaction entityTransaction = this.getEntityManager().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getTransaction took %dms", elapsed);
            }
        }
    }

    public boolean isOpen() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        return this.getEntityManager().isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinTransaction() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().joinTransaction();
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("joinTransaction took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().lock(entity, lockMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("lock entityClass '%s', lockMode '%s' took %dms", entity.getClass().getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            Object object = this.getEntityManager().merge(entity);
            return (T)object;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("merge entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().persist(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("persist entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, lockMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s', lockMode '%s' took %dms", entity.getClass().getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("refresh entityClass '%s', lockMode '%s' took %dms", entity.getClass().getName(), AbstractEntityManager.getLockModeAsString(lockMode), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.transactionIsRequired();
            this.getEntityManager().remove(entity);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("remove entityClass '%s' took %dms", entity.getClass().getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            this.getEntityManager().setFlushMode(flushMode);
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("setFlushMode took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaUpdate criteriaUpdate) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createQuery(criteriaUpdate);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery(CriteriaUpdate) took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaDelete criteriaDelete) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            Query query = this.getEntityManager().createQuery(criteriaDelete);
            return query;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createQuery(criteriaDelete) took %dms", elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createNamedStoredProcedureQuery(name);
            return storedProcedureQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createNamedStoredProcedureQuery %s took %dms", name, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName);
            return storedProcedureQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createStoredProcedureQuery %s took %dms", procedureName, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName, resultClasses);
            return storedProcedureQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createStoredProcedureQuery %s, resultClasses... took %dms", procedureName, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            StoredProcedureQuery storedProcedureQuery = this.getEntityManager().createStoredProcedureQuery(procedureName, resultSetMappings);
            return storedProcedureQuery;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createStoredProcedureQuery %s, resultSetMappings... took %dms", procedureName, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> EntityGraph<T> createEntityGraph(Class<T> tClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityGraph entityGraph = this.getEntityManager().createEntityGraph(tClass);
            return entityGraph;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createEntityGraph %s took %dms", tClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> createEntityGraph(String s) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityGraph entityGraph = this.getEntityManager().createEntityGraph(s);
            return entityGraph;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("createEntityGraph %s took %dms", s, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> getEntityGraph(String s) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            EntityGraph entityGraph = this.getEntityManager().getEntityGraph(s);
            return entityGraph;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getEntityGraph %s took %dms", s, elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> tClass) {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            List list = this.getEntityManager().getEntityGraphs(tClass);
            return list;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("getEntityGraphs %s took %dms", tClass.getName(), elapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinedToTransaction() {
        long start = 0L;
        if (this.isTraceEnabled) {
            start = System.currentTimeMillis();
        }
        try {
            boolean bl = this.getEntityManager().isJoinedToTransaction();
            return bl;
        }
        finally {
            if (this.isTraceEnabled) {
                long elapsed = System.currentTimeMillis() - start;
                JpaLogger.ROOT_LOGGER.tracef("isJoinedToTransaction() took %dms", elapsed);
            }
        }
    }

    protected void detachNonTxInvocation(EntityManager underlyingEntityManager) {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            underlyingEntityManager.clear();
        }
    }

    protected Query detachQueryNonTxInvocation(EntityManager underlyingEntityManager, Query underLyingQuery) {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            return new QueryNonTxInvocationDetacher(underlyingEntityManager, underLyingQuery);
        }
        return underLyingQuery;
    }

    protected TypedQuery detachTypedQueryNonTxInvocation(EntityManager underlyingEntityManager, TypedQuery underLyingQuery) {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            return new TypedQueryNonTxInvocationDetacher(underlyingEntityManager, underLyingQuery);
        }
        return underLyingQuery;
    }

    private void transactionIsRequired() {
        if (!this.isExtendedPersistenceContext() && !this.isInTx()) {
            throw JpaMessages.MESSAGES.transactionRequired();
        }
    }

    private static String getLockModeAsString(LockModeType lockMode) {
        if (lockMode == null) {
            return "(null)";
        }
        switch (lockMode) {
            case OPTIMISTIC: {
                return "optimistic";
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return "optimistic_force_increment";
            }
            case READ: {
                return "read";
            }
            case WRITE: {
                return "write";
            }
            case PESSIMISTIC_READ: {
                return "pessimistic_read";
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return "pessimistic_force_increment";
            }
        }
        return "none";
    }
}

