/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import javax.naming.Context;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.FixedInjectionSource;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.OptionalLookupInjectionSource;
import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public final class InjectionUtils {
    private static final String JAVAX_NAMING_CONTEXT_INJECTION_TYPE = Context.class.getName();
    private static final String JAVA_NET_URL_INJECTION_TYPE = URL.class.getName();

    private InjectionUtils() {
    }

    public static AccessibleObject getInjectionTarget(String injectionTargetClassName, String injectionTargetName, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        Class<?> current;
        Class<?> injectionTargetClass;
        try {
            injectionTargetClass = classLoader.loadClass(injectionTargetClassName);
        }
        catch (ClassNotFoundException e) {
            throw EeMessages.MESSAGES.cannotLoad(e, injectionTargetClassName);
        }
        ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(injectionTargetClass);
        String methodName = "set" + injectionTargetName.substring(0, 1).toUpperCase(Locale.ENGLISH) + injectionTargetName.substring(1);
        boolean methodFound = false;
        AccessibleObject method = null;
        Field field = null;
        for (current = injectionTargetClass; current != Object.class && current != null && !methodFound; current = current.getSuperclass()) {
            Collection methods = index.getAllMethods(methodName);
            for (Method m : methods) {
                if (m.getParameterTypes().length != 1 || m.isBridge() || m.isSynthetic()) continue;
                if (methodFound) {
                    throw EeMessages.MESSAGES.multipleSetterMethodsFound(injectionTargetName, injectionTargetClassName);
                }
                methodFound = true;
                method = m;
            }
        }
        if (method == null) {
            for (current = injectionTargetClass; current != Object.class && current != null && field == null && (field = index.getField(injectionTargetName)) == null; current = current.getSuperclass()) {
            }
        }
        if (field == null && method == null) {
            throw EeMessages.MESSAGES.cannotResolveInjectionPoint(injectionTargetName, injectionTargetClassName);
        }
        return field != null ? field : method;
    }

    public static InjectionSource getInjectionSource(final String name, String type) throws DeploymentUnitProcessingException {
        if (type.equals(JAVA_NET_URL_INJECTION_TYPE)) {
            ManagedReferenceFactory managedReferenceFactory = new ManagedReferenceFactory(){

                public ManagedReference getReference() {
                    try {
                        return new ImmediateManagedReference((Object)new URL(name));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            try {
                return new FixedInjectionSource(managedReferenceFactory, new URL(name));
            }
            catch (MalformedURLException e) {
                throw EeMessages.MESSAGES.cannotParseResourceRefUri(e, name);
            }
        }
        return JAVAX_NAMING_CONTEXT_INJECTION_TYPE.equals(type) ? new OptionalLookupInjectionSource(name) : new LookupInjectionSource(name);
    }
}

