/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerImpl;
import org.apache.ws.security.util.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SAMLIssuerFactory {
    private static final Log LOG = LogFactory.getLog(SAMLIssuerFactory.class);
    private static final Class<? extends SAMLIssuer> DEFAULT_SAML_CLASS = SAMLIssuerImpl.class;

    public static SAMLIssuer getInstance() throws WSSecurityException {
        return SAMLIssuerFactory.getInstance("saml.properties");
    }

    public static SAMLIssuer getInstance(Class<? extends SAMLIssuer> samlClass, Properties properties) throws WSSecurityException {
        return SAMLIssuerFactory.loadClass(samlClass, properties);
    }

    public static SAMLIssuer getInstance(Properties properties) throws WSSecurityException {
        String samlClassName = properties.getProperty("org.apache.ws.security.saml.issuerClass");
        Class<? extends SAMLIssuer> samlIssuerClass = null;
        if (samlClassName == null || samlClassName.equals("org.apache.ws.security.saml.SAMLIssuerImpl")) {
            samlIssuerClass = DEFAULT_SAML_CLASS;
        } else {
            try {
                samlIssuerClass = Loader.loadClass(samlClassName, SAMLIssuer.class);
            }
            catch (ClassNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                }
                throw new WSSecurityException(samlClassName + " Not Found", ex);
            }
        }
        return SAMLIssuerFactory.loadClass(samlIssuerClass, properties);
    }

    public static SAMLIssuer getInstance(String propFilename) throws WSSecurityException {
        return SAMLIssuerFactory.getInstance(SAMLIssuerFactory.getProperties(propFilename));
    }

    private static SAMLIssuer loadClass(Class<? extends SAMLIssuer> samlIssuerClass, Properties properties) throws WSSecurityException {
        SAMLIssuer samlIssuer = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using Crypto Engine [" + samlIssuerClass + "]"));
        }
        try {
            Class[] classes = new Class[]{Properties.class};
            Constructor<? extends SAMLIssuer> c = samlIssuerClass.getConstructor(classes);
            samlIssuer = c.newInstance(properties);
            return samlIssuer;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(samlIssuerClass.getName() + " cannot create instance", ex);
        }
    }

    private static Properties getProperties(String propFilename) throws WSSecurityException {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            if (url == null) {
                throw new WSSecurityException(0, "resourceNotFound", new Object[]{propFilename});
            }
            properties.load(url.openStream());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot find resource: " + propFilename), (Throwable)e);
            }
            throw new WSSecurityException(0, "resourceNotFound", new Object[]{propFilename}, e);
        }
        return properties;
    }
}

